# BRT Library

The Binaural Rendering Toolbox (BRT) is a set of software libraries, applications, and definitions aimed as a virtual laboratory for psychoacoustic experimentation. The BRT is developed in the framework of the [SONICOM project](https://www.sonicom.eu/) and include the algorithms developed in the [3D Tune-In Toolkit](https://github.com/3DTune-In/3dti\_AudioToolkit) in a new open, extensible architecture. 

Follow this link for the [official documentation of the whole Binaural Rendering Toolbox, including BRT Library and all associated applications](https://grupodiana.github.io/BRT-Documentation).

## Citable references:

First publication describing the architecture of the BRT, its main features, and how to apply it to conduct psychoacoustic experiments:

* González-Toledo D, Molina-Tanco L, Cuevas-Rodríguez M, Majdak P, Reyes-Lecuona, A. (2023) The Binaural Rendering Toolbox. A Virtual Laboratory for Reproducible Research in Psychoacoustics. In Proceedings of the 10th Convention of the European Acoustics Association. https://dael.euracoustics.org/confs/landing_pages/fa2023/001042.html

Technical details about the 3D Tune-In Toolkit spatialiser are described in:

* Cuevas-Rodríguez M, Picinali L, González-Toledo D, Garre C, de la Rubia-Cuestas E, Molina-Tanco L and Reyes-Lecuona A. (2019) 3D Tune-In Toolkit: An open-source library for real-time binaural spatialisation. PLOS ONE 14(3): e0211899. https://doi.org/10.1371/journal.pone.0211899

## Additional tools
In addition to this main repository, there are other repositories with associated tools:

* BRT Examples: basic spatialization example implemented in C++ to show how to use the BRT library. Code available at: https://github.com/GrupoDiana/BRTLibrary_Examples 
* BRT Examples for [OpenFrameworks](https://openframeworks.cc): only one example for IOS up to now.

## Credits

This software is being developed by a team coordinated by 
- [Arcadio Reyes-Lecuona](https://github.com/areyesl) ([Diana Research Group, University of Malaga](https://www.diana.uma.es/?page_id=53)). Contact: areyes@uma.es
- [Lorenzo Picinali](https://github.com/lpicinali) ([Audio Experience Design Team, Imperial College London](https://www.axdesign.co.uk)). Contact: l.picinali@imperial.ac.uk  

The current members of the development team are (in alphabetical order):
- [Maria Cuevas-Rodriguez](https://github.com/mariacuevas) ([University of Malaga](https://www.uma.es/))
- [Daniel Gonzalez-Toledo](https://github.com/dgonzalezt) ([University of Malaga](https://www.uma.es/))
- [Luis Molina-Tanco](https://github.com/lmtanco) ([University of Malaga](https://www.uma.es/))

Other contributors:

- [Francisco Morales Benítez](https://github.com/FranMoraUma) (Former contributor at the [University of Malaga](https://www.uma.es/) mainly in BeRTA GUI and BeRTA renderer)
- [Marco Fontana](https://github.com/MarcoFontana) (Developer of SDN Environment Model at the [Laboratorio di Informatica Musicale](https://www.lim.di.unimi.it), Università degli Studi di Milano)

## Copyright and License

This software is distributed under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

Copyright (c) for each module belongs to its respective authors, who may vary as there are contributions from different institutions in this software. This copyright information is specified in the headers of the corresponding files

This library includes pieces of code from the 3DTI AudioToolkit, shared under GPLv3 license and copyright (c) by University of Málaga (contact: areyes@uma.es) and Imperial College London (contact: l.picinali@imperial.ac.uk). See headers in the source code files.


## Acknowledgements 

![European Union](docs/images/EU_flag.png "European Union") This project has received funding from the European Union’s Horizon 2020 research and innovation programme under grant agreement no.101017743 

