/*===========================================================================*\
 *                                                                            *
 *  File name:      NC_IntegrationConstants.h                                 *
 *  Description:    Abscissas and weights for Gaussean numerical integration  *
 *  Author:         H. Ziegelwanger, W. Kreuzer and Z.S. Chen                 *
 *                                                                            *
 \*===========================================================================*/



#ifndef NC_IntegrationConstants_h
#define NC_IntegrationConstants_h



//================================= I N C L U D E S ==================================
// local includes                                                                   //
//                                                                                  //
// system includes                                                                  //
//====================================================================================



#define N_GAUORDER  80

const double GCoorWei_1[1][2] = {0.0, 2.0};

const double GCoorWei_2[1][2] = {0.577350269189626, 1.0};

const double GCoorWei_3[2][2] = {
	0.0,               0.888888888888889,
	0.774596669241483, 0.555555555555556
};
 
const double GCoorWei_4[2][2] = {
	0.339981043584856, 0.652145154862546,
	0.861136311594053, 0.347854845137454
};

const double GCoorWei_5[3][2] = {
	0.0,               0.568888888888889,
	0.538469310105683, 0.478628670499366,
	0.906179845938664, 0.236926885056189
};

const double GCoorWei_6[3][2] = {
	0.238619186083197, 0.467913934572691,
	0.661209386466265, 0.360761573048139,
	0.932469514203152, 0.171324492379170
};

const double GCoorWei_7[4][2] = {
	0.000000000000000, 0.417959183673469,
	0.405845151377397, 0.381830050505119,
	0.741531185599394, 0.279705391489277,
	0.949107912342759, 0.129484966168870
};

const double GCoorWei_8[4][2] = {
	0.183434642495650, 0.362683783378362,
	0.525532409916329, 0.313706645877887,
	0.796666477413627, 0.222381034453374,
	0.960289856497536, 0.101228536290376
};

const double GCoorWei_9[5][2] = {
	0.000000000000000, 0.330239355001260,
	0.324253423403809, 0.312347077040003,
	0.613371432700590, 0.260610696402935,
	0.836031107326636, 0.180648160694857,
	0.968160239507626, 0.081274388361574
};

const double GCoorWei_10[5][2] = {
	0.148874338981631, 0.295524224714735,
	0.433395394129247, 0.269266719309996,
	0.679409568299024, 0.219086362515982,
	0.865063366688985, 0.149451349150581,
	0.973906528517172, 0.066671344308688
};

const double GCoorWei_11[6][2] = {
	0.000000000000000, 0.272925086777901,
	0.269543155952346, 0.262804544510249,
	0.519096129206809, 0.233193764591982,
	0.730152005574049, 0.186290210927730,
	0.887062599768095, 0.125580369464901,
	0.978228658146057, 0.055668567116176
};

const double GCoorWei_12[6][2] = {
	0.125233408511469, 0.249147045813403,
	0.367831498998180, 0.233492536538355,
	0.587317954286617, 0.203167426723066,
	0.769902674194305, 0.160078328543346,
	0.904117256370475, 0.106939325995318,
	0.981560634246719, 0.047175336386512
};

const double GCoorWei_13[7][2] = {
	0.000000000000000, 0.232551553230874,
	0.230458315955134, 0.226283180262896,
	0.448492751036445, 0.207816047536882,
	0.642349339440342, 0.178145980761953,
	0.801578090733310, 0.138873510219788,
	0.917598399222979, 0.092121499837736,
	0.984183054718588, 0.040484004765316
};

const double GCoorWei_14[7][2] = {
	0.108054948707347, 0.215263853463160,
	0.319112368927890, 0.205198463721296,
	0.515248636358153, 0.185538397477935,
	0.687292904811685, 0.157203167158192,
	0.827201315069764, 0.121518570687897,
	0.928434883663573, 0.080158087159755,
	0.986283808696812, 0.035119460331748
};

const double GCoorWei_15[8][2] = {
	0.000000000000000, 0.202578241925561,
	0.201194093997432, 0.198431485327108,
	0.394151347077563, 0.186161000015561,
	0.570972172608538, 0.166269205816988,
	0.724417731360171, 0.139570677926158,
	0.848206583410427, 0.107159220467171,
	0.937273392400706, 0.070366047488112,
	0.987992518020485, 0.030753241996115
};

const double GCoorWei_16[8][2] = {
	0.095012509837637440185, 0.189450610455068496285,
	0.281603550779258913230, 0.182603415044923588867,
	0.458016777657227386342, 0.169156519395002538189,
	0.617876244402643748447, 0.149595988816576732081,
	0.755404408355003033895, 0.124628971255533872052,
	0.865631202387831743880, 0.095158511682492784810,
	0.944575023073232576078, 0.062253523938647892863,
	0.989400934991649932596, 0.027152459411754094852
};

const double GCoorWei_17[9][2] = {
	0.000000000000000, 0.179446470356207,
	0.178484181495845, 0.176562705366990,
	0.351231763453879, 0.168004102156456,
	0.512690537086475, 0.154045761076805,
	0.657671159216690, 0.135136368468519,
	0.781514003896802, 0.111883847193410,
	0.880239153726985, 0.085036148317169,
	0.950675521768767, 0.055459529373978,
	0.990575475314417, 0.024148302868543
};

const double GCoorWei_18[9][2] = {
	0.084775013041735, 0.169142382963143,
	0.251886225691507, 0.164276483745834,
	0.411751161462842, 0.154684675126262,
	0.559770831073948, 0.140642914670652,
	0.691687043060352, 0.122555206711471,
	0.803704958972523, 0.100942044106288,
	0.892602466497556, 0.076425730254888,
	0.955823949571397, 0.049714548894963,
	0.991565168420931, 0.021616013526485
};

const double GCoorWei_19[10][2] = {
	0.000000000000000, 0.161054449848784,
	0.160358645640226, 0.158968843393955,
	0.316564099963628, 0.152766042065857,
	0.464570741375959, 0.142606702173601,
	0.600545304661681, 0.128753962539335,
	0.720966177335228, 0.111566645547326,
	0.822714656537142, 0.091490021622445,
	0.903155903614817, 0.069044542737634,
	0.960208152134830, 0.044814226765693,
	0.992406843843584, 0.019461788229729
};

const double GCoorWei_20[10][2] = {
	0.076526521133497333755, 0.152753387130725850698,
	0.227785851141645078080, 0.149172986472603746788,
	0.373706088715419560673, 0.142096109318382051329,
	0.510867001950827098004, 0.131688638449176626898,
	0.636053680726515025453, 0.118194531961518417312,
	0.746331906460150792614, 0.101930119817240435037,
	0.839116971822218823395, 0.083276741576704748725,
	0.912234428251325905868, 0.062672048334109063570,
	0.963971927277913791268, 0.040601429800386941331,
	0.993128599185094924786, 0.017614007139152118312
};

const double GCoorWei_21[11][2] = {
	0.000000000000000, 0.146081133649690,
	0.145561854160894, 0.144524403989969,
	0.288021316802400, 0.139887394791072,
	0.424342120207438, 0.132268938633336,
	0.551618835887220, 0.121831416053732,
	0.667138804197413, 0.108797299167153,
	0.768439963475679, 0.093444423456043,
	0.853363364583318, 0.076100113628387,
	0.920099334150401, 0.057134425426853,
	0.967226838566306, 0.036953789770847,
	0.993752170620390, 0.016017228257779
};

const double GCoorWei_22[11][2] = {
	0.069739273319725, 0.139251872855633,
	0.207860426688222, 0.136541498346015,
	0.341935820892085, 0.131173504787063,
	0.469355837986758, 0.123252376810517,
	0.587640403506912, 0.112932296080541,
	0.694487263186682, 0.100414144442878,
	0.787816805979209, 0.085941606217074,
	0.865812577720299, 0.069796468424511,
	0.926956772187174, 0.052293335152681,
	0.970060497835429, 0.033774901584817,
	0.994294585482399, 0.014627995298269
};

const double GCoorWei_23[12][2] = {
	0.000000000000000, 0.133654572186106,
	0.133256824298464, 0.132462039404695,
	0.264135680970345, 0.128905722188081,
	0.390301038030293, 0.123049084306734,
	0.509501477846009, 0.114996640222417,
	0.619609875763644, 0.104892091464533,
	0.718661363131949, 0.092915766060029,
	0.804888401618839, 0.079281411776714,
	0.876752358270442, 0.064232421408524,
	0.932971086826016, 0.048037671731087,
	0.972542471218115, 0.030988005856974,
	0.994769334997552, 0.013411859487144
};

const double GCoorWei_24[12][2] = {
	0.064056892862605626085, 0.127938195346752156974,
	0.191118867473616309159, 0.125837456346828296121,
	0.315042679696163374387, 0.121670472927803391204,
	0.433793507626045138487, 0.115505668053725601353,
	0.545421471388839535658, 0.107444270115965634783,
	0.648093651936975569252, 0.097618652104113888270,
	0.740124191578554364244, 0.086190161531953275917,
	0.820001985973902921954, 0.073346481411080305734,
	0.886415527004401034213, 0.059298584915436780746,
	0.938274552002732758524, 0.044277438817419806169,
	0.974728555971309498198, 0.028531388628933663181,
	0.995187219997021360180, 0.012341229799987199547
};

const double GCoorWei_25[13][2] = {
	0.000000000000000, 0.123176053726715,
	0.122864692610710, 0.122242442990310,
	0.243866883720989, 0.119455763535786,
	0.361172305809386, 0.114858259145707,
	0.473002731445714, 0.108519624474262,
	0.577662930241222, 0.100535949067048,
	0.673566368473469, 0.091028261982969,
	0.759259263037358, 0.080140700335006,
	0.833442628760834, 0.068038333812353,
	0.894991997878275, 0.054904695975834,
	0.942974571228975, 0.040939156701314,
	0.976663921459518, 0.026354986615033,
	0.995556969790498, 0.011393798501025
};

const double GCoorWei_26[13][2] = {
	0.059230093429315, 0.118321415279263,
	0.176858820356891, 0.116660443485298,
	0.292004839485957, 0.113361816546320,
	0.403051755123485, 0.108471840528572,
	0.508440714824504, 0.102059161094420,
	0.606692293017617, 0.094213800355910,
	0.696427260419958, 0.085045894313490,
	0.776385948820680, 0.074684149765666,
	0.845445942788498, 0.063274046329574,
	0.902637861984307, 0.050975825297149,
	0.947159066661714, 0.037962383294356,
	0.978385445956471, 0.024417851092627,
	0.995885701145617, 0.010551372617342
};

const double GCoorWei_27[14][2] = {
	0.000000000000000, 0.114220867378957,
	0.113972585609530, 0.113476346108965,
	0.226459365439536, 0.111252488356844,
	0.335993903638510, 0.107578285788535,
	0.441148251750025, 0.102501637817742,
	0.540551564579459, 0.096088727370036,
	0.632907971946495, 0.088423158543758,
	0.717013473739424, 0.079604867773063,
	0.791771639070507, 0.069748823766237,
	0.856207908018295, 0.058983536859838,
	0.909482320677490, 0.047449412520606,
	0.950900557814705, 0.035297053757423,
	0.979923475961501, 0.022686231596174,
	0.996179262888989, 0.009798996051298
};

const double GCoorWei_28[14][2] = {
	0.055079289884034, 0.110047013016475,
	0.164569282133379, 0.108711192258292,
	0.272061627635177, 0.106055765922845,
	0.376251516089078, 0.102112967578060,
	0.475874224955119, 0.096930657997932,
	0.569720471811403, 0.090571744393039,
	0.656651094038866, 0.083113417228909,
	0.735610878013632, 0.074646214234567,
	0.805641370917179, 0.065272923967000,
	0.865892522574395, 0.055107345675713,
	0.915633026392133, 0.044272934759010,
	0.954259280628938, 0.032901427782306,
	0.981303165370873, 0.021132112592766,
	0.996442497573954, 0.009124282593092
};

const double GCoorWei_29[15][2] = {
	0.000000000000000, 0.106479381718314,
	0.106278230132678, 0.105876155097320,
	0.211352286166001, 0.104073310077729,
	0.314031637867640, 0.101091273759916,
	0.413152888174010, 0.096963834094412,
	0.507592955124227, 0.091737757139256,
	0.596281797138227, 0.085472257366170,
	0.678214537602685, 0.078238327135758,
	0.752462851734478, 0.070117933255054,
	0.818185487615252, 0.061203090657078,
	0.874637804920103, 0.051594826902504,
	0.921180232953059, 0.041402062518682,
	0.957285595778088, 0.030740492202093,
	0.982545505261413, 0.019732085056128,
	0.996679442260597, 0.008516903878746
};

const double GCoorWei_30[15][2] = {
	0.051471842555319, 0.102852652893559,
	0.153869913608585, 0.101762389748407,
	0.254636926167889, 0.099593420586795,
	0.352704725530876, 0.096368737174640,
	0.447033769538088, 0.092122522237782,
	0.536624148142020, 0.086899787201084,
	0.620526182989243, 0.080755895229420,
	0.697850494793316, 0.073755974737704,
	0.767777432104826, 0.065974229882176,
	0.829565762382768, 0.057493156217615,
	0.882560535792052, 0.048402672830587,
	0.926200047429274, 0.038799192569619,
	0.960021864968308, 0.028784707883324,
	0.983668123279747, 0.018466468311090,
	0.996893484074650, 0.007968192496167
};

const double GCoorWei_31[16][2] = {
	0.000000000000000, 0.099720544793426,
	0.099555312152340, 0.099225011226671,
	0.198121199335571, 0.097743335386329,
	0.294718069981702, 0.095290242912320,
	0.388385901608234, 0.091890113893645,
	0.478193782044902, 0.087576740608475,
	0.563249161407148, 0.082392991761585,
	0.642706722924259, 0.076390386598771,
	0.715776784586854, 0.069628583235414,
	0.781733148416625, 0.062174786561031,
	0.839920320146267, 0.054103082424912,
	0.889760029948272, 0.045493707527207,
	0.930756997896648, 0.036432273912385,
	0.962503925092949, 0.027009019184974,
	0.984685909665152, 0.017318620790306,
	0.997087481819477, 0.007470831579246
};

const double GCoorWei_32[16][2] = {
	0.048307665687738316235, 0.096540088514727800567,
	0.144471961582796493485, 0.095638720079274859419,
	0.239287362252137074545, 0.093844399080804565639,
	0.331868602282127649780, 0.091173878695763884713,
	0.421351276130635345364, 0.087652093004403811143,
	0.506899908932229390024, 0.083311924226946755222,
	0.587715757240762329041, 0.078193895787070306472,
	0.663044266930215200975, 0.072345794108848506225,
	0.732182118740289680387, 0.065822222776361846838,
	0.794483795967942406963, 0.058684093478535547145,
	0.849367613732569970134, 0.050998059262376176196,
	0.896321155766052123965, 0.042835898022226680657,
	0.934906075937739689171, 0.034273862913021433103,
	0.964762255587506430774, 0.025392065309262059456,
	0.985611511545268335400, 0.016274394730905670605,
	0.997263861849481563545, 0.007018610009470096600
};

const double GCoorWei_33[17][2] = {
	0.000000000000000, 0.093768446160210,
	0.093631065854727, 0.093356426065593,
	0.186439298827986, 0.092123986643310,
	0.277609097152495, 0.090081958660635,
	0.366339257748072, 0.087248287618841,
	0.451850017272446, 0.083647876067025,
	0.533389904786345, 0.079312364794878,
	0.610242345836381, 0.074279854843964,
	0.681731959969742, 0.068594572818650,
	0.747230496449564, 0.062306482530327,
	0.806162356274170, 0.055470846631688,
	0.858009652676505, 0.048147742818725,
	0.902316767743433, 0.040401541331667,
	0.938694372611167, 0.032300358632309,
	0.966822909689993, 0.023915548101751,
	0.986455726230643, 0.015321701512947,
	0.997424694246455, 0.006606227847593
};

const double GCoorWei_34[17][2] = {
	0.045509821953100, 0.090956740330259,
	0.136152357259180, 0.090203044370638,
	0.225666691616450, 0.088701897835694,
	0.313311081339459, 0.086465739747026,
	0.398359277758645, 0.083513099699843,
	0.480106545190327, 0.079868444339772,
	0.557875500669743, 0.075561974660017,
	0.631021727080530, 0.070629375814263,
	0.698939113216262, 0.065111521554070,
	0.761064876629870, 0.059054135827505,
	0.816884227900935, 0.052507414572691,
	0.865934638334564, 0.045525611523347,
	0.907809677718326, 0.038166593796409,
	0.942162397405106, 0.030491380638429,
	0.968708262533344, 0.022563721985485,
	0.987227816406310, 0.014450162748606,
	0.997571753790842, 0.006229140555911
};

const double GCoorWei_35[18][2] = {
	0.000000000000000, 0.088486794907104,
	0.088371343275664, 0.088140530430278,
	0.176051061165989, 0.087104446997183,
	0.262352941209295, 0.085386653392098,
	0.346601554430815, 0.083000593728860,
	0.428137541517810, 0.079964942242313,
	0.506322773241489, 0.076303457155445,
	0.580545344749763, 0.072044794772552,
	0.650224364665889, 0.067222285269082,
	0.714814501556626, 0.061873671966065,
	0.773810252286910, 0.056040816212348,
	0.826749899092227, 0.049769370401364,
	0.873219125025222, 0.043108422326171,
	0.912854261359318, 0.036110115863464,
	0.945345148207827, 0.028829260108881,
	0.970437616039230, 0.021322979911498,
	0.987935764443852, 0.013650828348376,
	0.997706569099600, 0.005883433420445
};

const double GCoorWei_36[18][2] = {
	0.043018198473709, 0.085983275670395,
	0.128736103809379, 0.085346685739334,
	0.213500892316863, 0.084078218979659,
	0.296684995344032, 0.082187266704346,
	0.377672547119690, 0.079687828912073,
	0.455863944433420, 0.076598410645871,
	0.530680285926246, 0.072941885005656,
	0.601567658135981, 0.068745323835740,
	0.668001236585525, 0.064039797355035,
	0.729489171593558, 0.058860144245334,
	0.785576230132205, 0.053244713977749,
	0.835847166992473, 0.047235083490247,
	0.879929800890398, 0.040875750923652,
	0.917497774515660, 0.034213810770313,
	0.948272984399508, 0.027298621498573,
	0.972027691049698, 0.020181515297733,
	0.988586478902213, 0.012915947284077,
	0.997830462484086, 0.005565719664254
};

const double GCoorWei_37[19][2] = {
	0.000000000000000, 0.083768360993139,
	0.083670408954770, 0.083474573625863,
	0.166753930239855, 0.082595272236441,
	0.248667792791364, 0.081136624508462,
	0.328837429883708, 0.079108861837531,
	0.406700509318329, 0.076526207570538,
	0.481710877803209, 0.073406777248501,
	0.553342391861582, 0.069772451555702,
	0.621092608408922, 0.065648722872738,
	0.684486309130962, 0.061064516523240,
	0.743078833981968, 0.056051987998296,
	0.796459200509901, 0.050646297654812,
	0.844252987340558, 0.044885364662459,
	0.886124962155488, 0.038809602501956,
	0.921781437412464, 0.032461639847522,
	0.950972343262094, 0.025886036990548,
	0.973493030056485, 0.019129044489074,
	0.989185963214319, 0.012238780100317,
	0.997944582477914, 0.005273057279496
};

const double GCoorWei_38[19][2] = {
	0.040785147904583, 0.081525029280387,
	0.122084025337869, 0.080982493770598,
	0.202570453892115, 0.079901033243526,
	0.281708809790167, 0.078287844658214,
	0.358972440479439, 0.076153663548456,
	0.433847169432375, 0.073512692584738,
	0.505834717927931, 0.070382507066899,
	0.574456021047804, 0.066783937979126,
	0.639254415829683, 0.062740933392140,
	0.699798680379187, 0.058280399147013,
	0.755685903753971, 0.053432019910336,
	0.806544167605315, 0.048228061860746,
	0.852035021932361, 0.042703158504658,
	0.891855739004633, 0.036894081594029,
	0.925741332048583, 0.030839500545160,
	0.953466330933530, 0.024579739738232,
	0.974846328590153, 0.018156577709610,
	0.989739454266386, 0.011613444716468,
	0.998049930535688, 0.005002880749635
};

const double GCoorWei_39[20][2] = {
	0.000000000000000, 0.079527622139443,
	0.079443804608758, 0.079276222568370,
	0.158385339997833, 0.078523613287366,
	0.236325512461838, 0.077274552544685,
	0.312771559248183, 0.075536937322830,
	0.387240163971564, 0.073321753414274,
	0.459260512309133, 0.070643005970599,
	0.528377268660435, 0.067517630966221,
	0.594153454957282, 0.063965388138700,
	0.656173213432008, 0.060008736088580,
	0.714044435894532, 0.055672690340902,
	0.767401242931064, 0.050984665292136,
	0.815906297430141, 0.045974301108900,
	0.859252937999907, 0.040673276847946,
	0.897167119292992, 0.035115111498126,
	0.929409148486739, 0.029334955983909,
	0.955775212324652, 0.023369384832167,
	0.976098709333471, 0.017256229093717,
	0.990251536854686, 0.011034788939156,
	0.998147383066433, 0.004752944691635
};

const double GCoorWei_40[20][2] = {
	0.038772417506050821933, 0.077505947978424811264,
	0.116084070675255208483, 0.077039818164247965588,
	0.192697580701371099716, 0.076110361900626242372,
	0.268152185007253681141, 0.074723169057968264200,
	0.341994090825758473007, 0.072886582395804059061,
	0.413779204371605001525, 0.070611647391286779695,
	0.483075801686178712909, 0.067912045815233903826,
	0.549467125095128202076, 0.064804013456601038075,
	0.612553889667980237953, 0.061306242492928939167,
	0.671956684614179548379, 0.057439769099391551367,
	0.727318255189927103281, 0.053227846983936824355,
	0.778305651426519387695, 0.048695807635072232061,
	0.824612230833311663196, 0.043870908185673271992,
	0.865959503212259503821, 0.038782167974472017640,
	0.902098806968874296728, 0.033460195282547847393,
	0.932812808278676533361, 0.027937006980023401098,
	0.957916819213791655805, 0.022245849194166957262,
	0.977259949983774262663, 0.016421058381907888713,
	0.990726238699457006453, 0.010498284531152813615,
	0.998237709710559200350, 0.004521277098533191258
};

const double GCoorWei_41[21][2] = {
	0.000000000000000, 0.075695535647298,
	0.075623258989166, 0.075478747092717,
	0.150813354863993, 0.074829623176222,
	0.225139605633427, 0.073751882027229,
	0.298176277341824, 0.072251696861021,
	0.369505022640481, 0.070337660620815,
	0.438717277051412, 0.068020736760892,
	0.505416599199402, 0.065314196453514,
	0.569220941610217, 0.062233542580972,
	0.629764839072195, 0.058796420949865,
	0.686701502034951, 0.055022519242576,
	0.739704803069926, 0.050933454294614,
	0.788471145047407, 0.046552648368992,
	0.832721200401363, 0.041905195195927,
	0.872201511692442, 0.037017716703509,
	0.906685944758101, 0.031918211731702,
	0.935976987497855, 0.026635899207122,
	0.959906891730346, 0.021201063368773,
	0.978338673561083, 0.015644938407812,
	0.991167109699016, 0.009999938773903,
	0.998321588574771, 0.004306140358170
};

const double GCoorWei_42[21][2] = {
	0.036948943165351, 0.073864234232173,
	0.110645027208521, 0.073460813453469,
	0.183736806564854, 0.072656175243804,
	0.255825079342878, 0.071454714265169,
	0.326516124465415, 0.069862992492602,
	0.395423852042977, 0.067889703376526,
	0.462171912070422, 0.065545624364908,
	0.526395749931192, 0.062843558045000,
	0.587744597485112, 0.059798262227600,
	0.645883388869245, 0.056426369358005,
	0.700494590556174, 0.052746295699191,
	0.751279935689482, 0.048778140792815,
	0.797962053255487, 0.044543577771960,
	0.840285983261815, 0.040065735180672,
	0.878020569812172, 0.035369071097581,
	0.910959724904126, 0.030479240699586,
	0.938923557354989, 0.025422959526131,
	0.961759365338204, 0.020227869569046,
	0.979342508063748, 0.014922443697355,
	0.991577288340861, 0.009536220301748,
	0.998399618990062, 0.004105998604643
};

const double GCoorWei_43[22][2] = {
	0.000000000000000, 0.072215751693799,
	0.072152990874584, 0.072027501971421,
	0.143929809510712, 0.071463734252513,
	0.214956244860518, 0.070527387765085,
	0.284861998032909, 0.069223344193649,
	0.353282612864309, 0.067558402229377,
	0.419861376029271, 0.065541242126328,
	0.484251176785731, 0.063182380449382,
	0.546116316660086, 0.060494115249996,
	0.605134259639597, 0.057490461956894,
	0.660997313751496, 0.054187080318871,
	0.713414235268957, 0.050601192784391,
	0.762111747194954, 0.046751494754341,
	0.806835964136939, 0.042658057197986,
	0.847353716209316, 0.038342222194146,
	0.883453765218617, 0.033826492086867,
	0.914947907206139, 0.029134413261497,
	0.941671956847638, 0.024290456613836,
	0.963486613014081, 0.019319901423699,
	0.980278220980255, 0.014248756431572,
	0.991959557593244, 0.009103996637397,
	0.998472332242508, 0.003919490253850
};

const double GCoorWei_44[22][2] = {
	0.035289236964132, 0.070549157789353,
	0.105691901708651, 0.070197685473556,
	0.175568014775517, 0.069496491861573,
	0.244569456928201, 0.068449070269367,
	0.312352466502787, 0.067060638906295,
	0.378579352014706, 0.065338114879178,
	0.442920174525415, 0.063290079733215,
	0.505054391388201, 0.060926736701556,
	0.564672453185474, 0.058259859877607,
	0.621477345903578, 0.055302735563740,
	0.675186070666119, 0.052070096091687,
	0.725531053660716, 0.048578046448344,
	0.772261479248754, 0.044843984081957,
	0.815144539645134, 0.040886512310341,
	0.853966595004711, 0.036725347813810,
	0.888534238286043, 0.032381222812062,
	0.918675259984175, 0.027875782821265,
	0.944239509118193, 0.023231481902007,
	0.965099650422493, 0.018471481736814,
	0.981151833077914, 0.013619586755569,
	0.992316392138516, 0.008700481367528,
	0.998540200636774, 0.003745404803109
};

const double GCoorWei_45[23][2] = {
	0.000000000000000, 0.069041824829232,
	0.068986980163144, 0.068877316977661,
	0.137645205983254, 0.068384577378670,
	0.205647489783258, 0.067565954163600,
	0.272669769752381, 0.066425348449849,
	0.338392654250605, 0.064968195750729,
	0.402502943858540, 0.063201440073816,
	0.464695123919634, 0.061133500831064,
	0.524672820462914, 0.058774232718833,
	0.582150212569356, 0.056134878759798,
	0.636853394453225, 0.053228016731277,
	0.688521680771198, 0.050067499237936,
	0.736908848945489, 0.046668387718362,
	0.781784312593906, 0.043046880709162,
	0.822934220502085, 0.039220236729293,
	0.860162475960663, 0.035206692201595,
	0.893291671753241, 0.031025374934506,
	0.922163936719000, 0.026696213967573,
	0.946641690995630, 0.022239847550594,
	0.966608310396895, 0.017677535257944,
	0.981968715034541, 0.013031104991588,
	0.992649998447204, 0.008323189296216,
	0.998603645181937, 0.003582663155287
};

const double GCoorWei_46[23][2] = {
	0.033772190016047, 0.067518685849035,
	0.101162475305580, 0.067210613600676,
	0.168091179467102, 0.066595874768453,
	0.234252922206268, 0.065677274267778,
	0.299345822701866, 0.064459003467132,
	0.363072877020994, 0.062946621064391,
	0.425143313282830, 0.061147027724655,
	0.485273918388163, 0.059068434595541,
	0.543190330261800, 0.056720325843980,
	0.598628289712713, 0.054113415385845,
	0.651334846202000, 0.051259598007155,
	0.701069512020404, 0.048171895101702,
	0.747605359615668, 0.044864395277330,
	0.790730057075273, 0.041352190109666,
	0.830246837066066, 0.037651305357386,
	0.865975394866856, 0.033778627999087,
	0.897752711533942, 0.029751829552202,
	0.925433798806753, 0.025589286397121,
	0.948892363446091, 0.021309998754152,
	0.968021391853991, 0.016933514007820,
	0.982733669804167, 0.012479883770989,
	0.992962348906175, 0.007969898229733,
	0.998663042133818, 0.003430300868104
};

const double GCoorWei_47[24][2] = {
	0.000000000000000, 0.066135129623655,
	0.066086923916355, 0.065990533588810,
	0.131884866554520, 0.065557377766554,
	0.197106110279115, 0.064837556238950,
	0.261465459214970, 0.063834216605709,
	0.324681486337733, 0.062551746220916,
	0.386477764084670, 0.060995753008746,
	0.446584073104855, 0.059173040942337,
	0.504737583863578, 0.057091580293231,
	0.560684005934666, 0.054760472781538,
	0.614178699956374, 0.052189911780059,
	0.664987747390331, 0.049391137747354,
	0.712888973409067, 0.046376389086526,
	0.757672918445437, 0.043158848648466,
	0.799143754167743, 0.039752586122542,
	0.837120139899903, 0.036172496584180,
	0.871436015796896, 0.032434235515185,
	0.901941329438526, 0.028554150700647,
	0.928502693012359, 0.024549211659640,
	0.951003969257709, 0.020436938147682,
	0.969346787326564, 0.016235333146431,
	0.983451003071624, 0.011962848464312,
	0.993255210987769, 0.007638616295846,
	0.998718728584212, 0.003287453842524
};

const double GCoorWei_48[24][2] = {
	0.032380170962869362033, 0.064737696812683922503,
	0.097004699209462698930, 0.064466164435950082207,
	0.161222356068891718056, 0.063924238584648186624,
	0.224763790394689061225, 0.063114192286254025657,
	0.287362487355455576736, 0.062039423159892663904,
	0.348755886292160738160, 0.060704439165893880053,
	0.408686481990716729916, 0.059114839698395635746,
	0.466902904750958404545, 0.057277292100403215705,
	0.523160974722233033678, 0.055199503699984162868,
	0.577224726083972703818, 0.052890189485193667096,
	0.628867396776513623995, 0.050359035553854474958,
	0.677872379632663905212, 0.047616658492490474826,
	0.724034130923814654674, 0.044674560856694280419,
	0.767159032515740339254, 0.041545082943464749214,
	0.807066204029442627083, 0.038241351065830706317,
	0.843588261624393530711, 0.034777222564770438893,
	0.876572020274247885906, 0.031167227832798088902,
	0.905879136715569672822, 0.027426509708356948200,
	0.931386690706554333114, 0.023570760839324379141,
	0.952987703160430860723, 0.019616160457355527814,
	0.970591592546247250461, 0.015579315722943848728,
	0.984124583722826857745, 0.011477234579234539490,
	0.993530172266350757548, 0.007327553901276262102,
	0.998771007252426118601, 0.003153346052305838633
};

const double GCoorWei_49[25][2] = {
	0.000000000000000, 0.063463281404791,
	0.063420684982688, 0.063335509296492,
	0.126585997269669, 0.062952707465193,
	0.189241592461807, 0.062316417320049,
	0.251135178612567, 0.061429200979176,
	0.312017532119751, 0.060294630953156,
	0.371643501262285, 0.058917275760028,
	0.429772993341579, 0.057302681530194,
	0.486171941452502, 0.055457349674838,
	0.540613246991733, 0.053388710708287,
	0.592877694108902, 0.051105094330152,
	0.642754832419230, 0.048615695887790,
	0.690043824425128, 0.045930539355571,
	0.734554254237396, 0.043060436981215,
	0.776106894345449, 0.040016945766388,
	0.814534427359856, 0.036812320963002,
	0.849682119844164, 0.033459466791608,
	0.881408445573007, 0.029971884620561,
	0.909585655828073, 0.026363618927069,
	0.934100294755812, 0.022649201587472,
	0.954853658674139, 0.018843595853124,
	0.971762200901556, 0.014962144935631,
	0.984757895914213, 0.011020551031606,
	0.993788661944168, 0.007035099590094,
	0.998820150606635, 0.003027278988929
};

const double GCoorWei_50[25][2] = {
	0.031098338327194, 0.062176616655348,
	0.093174701560075, 0.061936067420677,
	0.154890589998144, 0.061455899590315,
	0.216007236876033, 0.060737970841758,
	0.276288193779539, 0.059785058704278,
	0.335500245419442, 0.058600849813234,
	0.393414311897555, 0.057189925647701,
	0.449806334974038, 0.055557744806209,
	0.504458144907455, 0.053710621888962,
	0.557158304514646, 0.051655703069565,
	0.607702927184957, 0.049400938449498,
	0.655896465685439, 0.046955051303948,
	0.701552468706816, 0.044327504338763,
	0.744494302226070, 0.041528463090159,
	0.784555832900404, 0.038568756612622,
	0.821582070859338, 0.035459835615163,
	0.855429769429944, 0.032213728223561,
	0.885967979523612, 0.028842993580525,
	0.913078556655790, 0.025360673569989,
	0.936656618944879, 0.021780243170143,
	0.956610955242808, 0.018115560713482,
	0.972864385106692, 0.014380822761476,
	0.985354084048005, 0.010590548383633,
	0.994031969432091, 0.006759799195757,
	0.998866404420071, 0.002908622553155
};

const double GCoorWei_51[26][2] = {
	0.000000000000000, 0.060998924841206,
	0.060961100150573, 0.060885464844854,
	0.121695421018882, 0.060545506934733,
	0.181977026957086, 0.059980315777513,
	0.241581666447801, 0.059191993922965,
	0.300287606335335, 0.058183473982597,
	0.357876456688407, 0.056958507720254,
	0.414133983226306, 0.055521652095744,
	0.468850904286050, 0.053878252313077,
	0.521823669366191, 0.052034421936717,
	0.572855216351303, 0.049997020150053,
	0.621755704600726, 0.047773626240636,
	0.668343221175369, 0.045372511407647,
	0.712444457577040, 0.042802607997903,
	0.753895354485378, 0.040073476285514,
	0.792541712099382, 0.037195268923269,
	0.828239763823065, 0.034178693204186,
	0.860856711182296, 0.031034971290199,
	0.890271218029529, 0.027775798594179,
	0.916373862309779, 0.024413300573761,
	0.939067544002962, 0.020959988401695,
	0.958267848613907, 0.017428714723374,
	0.973903368019325, 0.013832634006496,
	0.985915991735904, 0.010185191297840,
	0.994261260436753, 0.006500337783258,
	0.998909990848903, 0.002796807171081
};

const double GCoorWei_52[26][2] = {
	0.029914109797347, 0.059810365745293,
	0.089635244648902, 0.059596260171249,
	0.149035508606949, 0.059168815466043,
	0.207902264156378, 0.058529561771829,
	0.266024783605003, 0.057680787452528,
	0.323195003434819, 0.056625530902392,
	0.379208269116095, 0.055367569669305,
	0.433864067718771, 0.053911406932784,
	0.486966745698093, 0.052262255383898,
	0.538326209285819, 0.050426018566309,
	0.587758604979582, 0.048409269744089,
	0.635086977695248, 0.046219228372797,
	0.680141904227173, 0.043863734259032,
	0.722762099749982, 0.041351219500555,
	0.762794995193744, 0.038690678310417,
	0.800097283430468, 0.035891634835093,
	0.834535432326733, 0.032964109089705,
	0.865986162846064, 0.029918581147109,
	0.894336890534498, 0.026765953746534,
	0.919486128916426, 0.023517513554006,
	0.941343853641361, 0.020184891508016,
	0.959831826933087, 0.016780023396315,
	0.974883884221745, 0.013315114982357,
	0.986446195651551, 0.009802634579490,
	0.994477590929216, 0.006255523962988,
	0.998951111103950, 0.002691316950033
};

const double GCoorWei_53[27][2] = {
	0.000000000000000, 0.058718794151164,
	0.058685054300268, 0.058617586232723,
	0.117167809071957, 0.058314311362258,
	0.175246662155336, 0.057810014991725,
	0.232721403724264, 0.057106435536254,
	0.289393906451617, 0.056205998381722,
	0.345068808495722, 0.055111807523933,
	0.399554186953956, 0.053827634868740,
	0.452662219461846, 0.052357907229874,
	0.504209831657139, 0.050707691069314,
	0.554019328277073, 0.048882675032722,
	0.601919005713772, 0.046889150340765,
	0.647743743916511, 0.044733989103680,
	0.691335575601372, 0.042424620634551,
	0.732544230807509, 0.039969005843529,
	0.771227654925531, 0.037375609803477,
	0.807252498416896, 0.034653372583542,
	0.840494576545798, 0.031811678458986,
	0.870839297558241, 0.028860323617821,
	0.898182057875425, 0.025809482510742,
	0.922428603042810, 0.022669673057040,
	0.943495353464443, 0.019451721107661,
	0.961309694623136, 0.016166725256685,
	0.975810233714983, 0.012826026144208,
	0.986947035023372, 0.009441202284942,
	0.994681919308007, 0.006024276226956,
	0.998989947776328, 0.002591683720564
};

const double GCoorWei_54[27][2] = {
	0.028816748199336, 0.057617536707146,
	0.086354518263248, 0.057426137054112,
	0.143605427316266, 0.057043973558804,
	0.200379293606215, 0.056472315730628,
	0.256487520070007, 0.055713062560606,
	0.311743720834462, 0.054768736213046,
	0.365964340372193, 0.053642473647557,
	0.418969263255199, 0.052338016198284,
	0.470582412481392, 0.050859697146220,
	0.520632334385928, 0.049212427324511,
	0.568952768195213, 0.047401678806462,
	0.615383198331131, 0.045433466728293,
	0.659769387631978, 0.043314329309571,
	0.701963889719173, 0.041051306136643,
	0.741826538809185, 0.038651914782105,
	0.779224915346252, 0.036124125840372,
	0.814034785913564, 0.033476336464343,
	0.846140515970770, 0.030717342497837,
	0.875435454065570, 0.027856309310603,
	0.901822286284700, 0.024902741467185,
	0.925213359866651, 0.021866451422849,
	0.945530975164995, 0.018757527621449,
	0.962707645785922, 0.015586303035890,
	0.976686328857904, 0.012363328128871,
	0.987420637397344, 0.009099369455535,
	0.994875117018339, 0.005805611015253,
	0.999026666867341, 0.002497481835748
};

const double GCoorWei_55[28][2] = {
	0.000000000000000, 0.056602976444560,
	0.056572753818339, 0.056512318249773,
	0.112964288059320, 0.056240634071078,
	0.168993963646883, 0.055788794195294,
	0.224482300647836, 0.055158246002495,
	0.279251553200816, 0.054351009329928,
	0.333126278890032, 0.053369670001623,
	0.385933900740973, 0.052217371545616,
	0.437505260037174, 0.050897805124491,
	0.487675158187475, 0.049415197711556,
	0.536282885908342, 0.047774298551197,
	0.583172738026028, 0.045980363946267,
	0.628194512249936, 0.044039140421647,
	0.671203990319826, 0.041956846317719,
	0.712063399986642, 0.039740151874363,
	0.750641856348024, 0.037396157867979,
	0.786815781127624, 0.034932372873604,
	0.820469298559323, 0.032356689226202,
	0.851494606617153, 0.029677357765146,
	0.879792322419894, 0.026902961456382,
	0.905271800744000, 0.024042388009724,
	0.927851424720789, 0.021104801667976,
	0.947458868041209, 0.018099614520693,
	0.964031328593135, 0.015036458333497,
	0.977515735503989, 0.011925160719835,
	0.987868941198890, 0.008775746107077,
	0.995057977847412, 0.005598632266540,
	0.999061419564819, 0.002408323619977
};

const double GCoorWei_56[28][2] = {
	0.027797035287264, 0.055579746306512,
	0.083305186822433, 0.055407952503244,
	0.138555846810380, 0.055064895901766,
	0.193378238635270, 0.054551636870883,
	0.247602909434338, 0.053869761865715,
	0.301062253867222, 0.053021378524013,
	0.353591032174952, 0.052009109151736,
	0.405026880927092, 0.050836082617800,
	0.455210814878462, 0.049505924683054,
	0.503987718384385, 0.048022746793614,
	0.551206824855536, 0.046391133373007,
	0.596722182770663, 0.044616127652692,
	0.640393106807006, 0.042703216084662,
	0.682084612694468, 0.040658311384729,
	0.721667834450194, 0.038487734259284,
	0.759020422705129, 0.036198193872315,
	0.794026922893868, 0.033796767115625,
	0.826579132142881, 0.031290876747309,
	0.856576433762750, 0.028688268473832,
	0.883926108327827, 0.025996987058390,
	0.908543620420656, 0.023225351562573,
	0.930352880247497, 0.020381929882413,
	0.949286479561961, 0.017475512911376,
	0.965285901905490, 0.014515089278018,
	0.978301709140256, 0.011509824340383,
	0.988293715540162, 0.008469063163331,
	0.995231226081070, 0.005402522246000,
	0.999094343801466, 0.002323855375785
};

const double GCoorWei_57[29][2] = {
	0.000000000000000, 0.054634328756584,
	0.054607151001639, 0.054552803604759,
	0.109051332808786, 0.054308471452498,
	0.163170062591271, 0.053902061483305,
	0.216801828796117, 0.053334786584809,
	0.269786573161839, 0.052608339729177,
	0.321966168395385, 0.051724888920532,
	0.373184890086587, 0.050687070724908,
	0.423289881451570, 0.049497982402037,
	0.472131609517975, 0.048161172661686,
	0.519564311391188, 0.046680631073643,
	0.565446429269235, 0.045060776161372,
	0.609641032908715, 0.043306442216211,
	0.652016228280983, 0.041422864870835,
	0.692445551199515, 0.039415665475462,
	0.730808344744522, 0.037290834324408,
	0.766990119359451, 0.035054712782321,
	0.800882894547223, 0.032713974366409,
	0.832385521150441, 0.030275604842715,
	0.861403983262044, 0.027746881402148,
	0.887851678882224, 0.025135350990951,
	0.911649678521390, 0.022448807890755,
	0.932726961067100, 0.019695270699466,
	0.951020626447879, 0.016882959023478,
	0.966476085171885, 0.014020270790722,
	0.979047226709469, 0.011115763732357,
	0.988696577650223, 0.008178160067847,
	0.995395523678431, 0.005216533474740,
	0.999125565625263, 0.002243753872257
};

const double GCoorWei_58[29][2] = {
	0.026847012365940, 0.053681119863334,
	0.080463630214140, 0.053526343304057,
	0.133848250595477, 0.053217236446587,
	0.186846951835762, 0.052754690526371,
	0.239306924966151, 0.052140039183665,
	0.291076914311106, 0.051375054618280,
	0.342007653597995, 0.050461942479952,
	0.391952296330747, 0.049403335508945,
	0.440766839186837, 0.048202285945409,
	0.488310537216711, 0.046862256729001,
	0.534446309648855, 0.045387111514851,
	0.579041135130232, 0.043781103533672,
	0.621966435263079, 0.042048863329580,
	0.663098445332124, 0.040195385409863,
	0.702318571153912, 0.038226013845884,
	0.739513731020042, 0.036146426867088,
	0.774576681749650, 0.033962620493397,
	0.807406327913087, 0.031680891253800,
	0.837908013339371, 0.029307818044136,
	0.865993794074806, 0.026850243181963,
	0.891582692022031, 0.024315252724975,
	0.914600928564351, 0.021710156140120,
	0.934982137588259, 0.019042465461888,
	0.952667557518870, 0.016319874234991,
	0.967606202502923, 0.013550237112969,
	0.979755014694350, 0.010741553532880,
	0.989079008248443, 0.007901973849994,
	0.995551476597291, 0.005039981612644,
	0.999155200407387, 0.002167723249622
};

const double GCoorWei_59[30][2] = {
	0.000000000000000, 0.052798012621990,
	0.052773484088314, 0.052724433859129,
	0.105399879016347, 0.052503902647830,
	0.157732505587852, 0.052137033648369,
	0.209625503392035, 0.051624849390889,
	0.260934237342802, 0.050968777425377,
	0.311515700803022, 0.050170646343013,
	0.361228914169795, 0.049232680679362,
	0.409935317810415, 0.048157494714597,
	0.457499158253266, 0.046948085186959,
	0.503787866557712, 0.045607822940487,
	0.548672427808391, 0.044140443530275,
	0.592027740704034, 0.042550036811087,
	0.633732966238844, 0.040841035538655,
	0.673671864504941, 0.039018203016181,
	0.711733118677200, 0.037086619818882,
	0.747810645278636, 0.035051669636370,
	0.781803889862360, 0.032919024271040,
	0.813618107288209, 0.030694627836088,
	0.843164625816871, 0.028384680200521,
	0.870361094292881, 0.025995619731289,
	0.895131711743471, 0.023534105393693,
	0.917407438788153, 0.021006998288405,
	0.937126190353455, 0.018421342753627,
	0.954233009376951, 0.015784347313083,
	0.968680221681781, 0.013103366306327,
	0.980427573956717, 0.010385885501025,
	0.989442365133731, 0.007639529453494,
	0.995699640383246, 0.004872239168245,
	0.999183353909295, 0.002095492284542
};

const double GCoorWei_60[30][2] = {
	0.025959772301251, 0.051907877631221,
	0.077809333949528, 0.051767943174906,
	0.129449135396938, 0.051488451500975,
	0.180739964873426, 0.051070156069856,
	0.231543551376019, 0.050514184532494,
	0.281722937423261, 0.049822035690549,
	0.331142848268458, 0.048995575455779,
	0.379670056576807, 0.048037031819995,
	0.427173741583069, 0.046948988848884,
	0.473525841761700, 0.045734379716092,
	0.518601400058568, 0.044396478795781,
	0.562278900753938, 0.042938892835906,
	0.604440597048516, 0.041365551235614,
	0.644972828489471, 0.039680695452348,
	0.683766327381359, 0.037888867569265,
	0.720716513355733, 0.035994898051098,
	0.755723775306587, 0.034003892724954,
	0.788693739932268, 0.031921219019331,
	0.819537526162143, 0.029752491500762,
	0.848171984785929, 0.027503556749921,
	0.874519922646897, 0.025180477621502,
	0.898510310810045, 0.022789516943990,
	0.920078476177626, 0.020337120729439,
	0.939166276116423, 0.017829901014200,
	0.955722255839995, 0.015274618596761,
	0.969701788765053, 0.012678166476817,
	0.981067201752598, 0.010047557182285,
	0.989787895222222, 0.007389931163342,
	0.995840525118838, 0.004712729926974,
	0.999210123227436, 0.002026811968863
};

const double GCoorWei_61[31][2] = {
	0.000000000000000, 0.051081119440786,
	0.051058906707984, 0.051014487038700,
	0.101984606562275, 0.050814763668819,
	0.152644240230824, 0.050482470386806,
	0.202905642518059, 0.050018474108179,
	0.252637687169057, 0.049423985346741,
	0.301710628963041, 0.048700555056431,
	0.349996442204072, 0.047850070585107,
	0.397369154725757, 0.046874750750810,
	0.443705176538523, 0.045777140053119,
	0.488883622262252, 0.044560102035084,
	0.532786626502923, 0.043226811812489,
	0.575299651350825, 0.041780747790863,
	0.616311785197926, 0.040225682591017,
	0.655716032095075, 0.038565673207032,
	0.693409590894491, 0.036805050423151,
	0.729294123449470, 0.034948407516563,
	0.763276011172313, 0.033000588275913,
	0.795266599282357, 0.030966674368373,
	0.825182428108659, 0.028851972088175,
	0.852945450847663, 0.026661998524151,
	0.878483237214885, 0.024402467187584,
	0.901729162474002, 0.022079273148327,
	0.922622581382957, 0.019698477746130,
	0.941108986681363, 0.017266292987648,
	0.957140151912984, 0.014789065884935,
	0.970674258833182, 0.012273263507784,
	0.981676011284037, 0.009725461830358,
	0.990116745232517, 0.007152354991748,
	0.995974599815120, 0.004560924005999,
	0.999235597631363, 0.001961453361672
};

const double GCoorWei_62[31][2] = {
	0.025129291421821, 0.050248000375256,
	0.075324395496241, 0.050121069569046,
	0.125329223615895, 0.049867528594951,
	0.175017459249019, 0.049488017919703,
	0.224263585604174, 0.048983496220530,
	0.272943202696726, 0.048355237963477,
	0.320933341594202, 0.047604830184119,
	0.368112775046557, 0.046734168478397,
	0.414362323717124, 0.045745452214564,
	0.459565157240113, 0.044641178977123,
	0.503607089344765, 0.043424138258080,
	0.546376866300249, 0.042097404410375,
	0.587766447953081, 0.040664328882390,
	0.627671280646884, 0.039128531751956,
	0.665990561335482, 0.037493892582295,
	0.702627492222293, 0.035764540622745,
	0.737489525283158, 0.033944844379421,
	0.770488596055416, 0.032039400581599,
	0.801541346103977, 0.030053022573993,
	0.830569333604004, 0.027990728163306,
	0.857499231512070, 0.025857726954015,
	0.882263012831898, 0.023659407208688,
	0.904798122521093, 0.021401322277670,
	0.925047635636205, 0.019089176658588,
	0.942960401392329, 0.016728811790189,
	0.958491172973928, 0.014326191823829,
	0.971600723371651, 0.011887390117002,
	0.982255949097236, 0.009418579428400,
	0.990429971189291, 0.006926041901840,
	0.996102296316267, 0.004416333456929,
	0.999259859308777, 0.001899205679516
};

const double GCoorWei_63[32][2] = {
	0.000000000000000, 0.049472366623931,
	0.049452187116166, 0.049411833039920,
	0.098783356446946, 0.049230380423748,
	0.147872786357872, 0.048928452820512,
	0.196600346791509, 0.048506789097887,
	0.244846793245953, 0.047966421137995,
	0.292494058586256, 0.047308671312277,
	0.339425541974578, 0.046535149245368,
	0.385526394212253, 0.045647747876307,
	0.430683798795110, 0.044648638825937,
	0.474787247994813, 0.043540267083057,
	0.517728813290030, 0.042325345020805,
	0.559403409486285, 0.041006845759664,
	0.599709051877632, 0.039587995891575,
	0.638547105821361, 0.038072267584326,
	0.675822528114982, 0.036463370085432,
	0.711444099584848, 0.034765240645370,
	0.745324648317846, 0.032982034883772,
	0.777381262990377, 0.031118116622257,
	0.807535495773456, 0.029178047208270,
	0.835713554319504, 0.027166574359109,
	0.861846482364125, 0.025088620553356,
	0.885870328507851, 0.022949271004859,
	0.907726302778532, 0.020753761258043,
	0.927360920621844, 0.018507464460167,
	0.944726134041010, 0.016215878410342,
	0.959779449758943, 0.013884612616132,
	0.972484034697571, 0.011519376076909,
	0.982808810593727, 0.009125968676306,
	0.990728546892190, 0.006710291765965,
	0.996224012777970, 0.004278508346872,
	0.999282984029124, 0.001839874595570
};

const double GCoorWei_64[32][2] = {
	0.024350292663426, 0.048690957009140,
	0.072993121787809, 0.048575467441508,
	0.121462819296122, 0.048344762234804,
	0.169644420423984, 0.047999388596449,
	0.217423643740013, 0.047540165714838,
	0.264687162208761, 0.046968182816199,
	0.311322871990218, 0.046284796581330,
	0.357220158337668, 0.045491627927419,
	0.402270157963991, 0.044590558163755,
	0.446366017253460, 0.043583724529311,
	0.489403145707052, 0.042473515123649,
	0.531279464019895, 0.041262563242626,
	0.571895646202630, 0.039953741132701,
	0.611155355172387, 0.038550153178585,
	0.648965471254654, 0.037055128540223,
	0.685236313054238, 0.035472213256912,
	0.719881850171608, 0.033805161837126,
	0.752819907260534, 0.032057928354866,
	0.783972358943345, 0.030234657072432,
	0.813265315122800, 0.028339672614284,
	0.840629296252580, 0.026377469715052,
	0.865999398154092, 0.024352702568701,
	0.889315445995116, 0.022270173808402,
	0.910522137078502, 0.020134823153518,
	0.929569172131940, 0.017951715775703,
	0.946411374858402, 0.015726030476006,
	0.961008799652055, 0.013463047896739,
	0.973326827789910, 0.011168139460114,
	0.983336253884626, 0.008846759826349,
	0.991013371476745, 0.006504457968992,
	0.996340116771955, 0.004147033260574,
	0.999305041735772, 0.001783280721702
};

const double GCoorWei_65[33][2] = {
	0.000000000000000, 0.047961849394467,
	0.047943462353178, 0.047906692500498,
	0.095776653209189, 0.047741348681236,
	0.143389554698979, 0.047466198232889,
	0.190672655626137, 0.047081874010447,
	0.237517203346409, 0.046589259972222,
	0.283815453902243, 0.045989489146641,
	0.329460919837479, 0.045283941026284,
	0.374348615122065, 0.044474238395079,
	0.418375296623418, 0.043562243595827,
	0.461439701569148, 0.042550054246767,
	0.503442780455006, 0.041439998417238,
	0.544287924862232, 0.040234629273024,
	0.583881189660490, 0.038936719204064,
	0.622131509085404, 0.037549253448277,
	0.658950906193627, 0.036075423225578,
	0.694254695213987, 0.034518618398520,
	0.727961676329425, 0.032882419676368,
	0.759994322441995, 0.031170590380153,
	0.790278957492122, 0.029387067789313,
	0.818745925922648, 0.027535954088415,
	0.845329752899929, 0.025621506938026,
	0.869969294926406, 0.023648129691270,
	0.892607880504739, 0.021620361284933,
	0.913193440542845, 0.019542865836739,
	0.931678628228747, 0.017420421997637,
	0.948020928168407, 0.015257912146436,
	0.962182754718054, 0.013060311639961,
	0.974131539833551, 0.010832678789595,
	0.983839812187036, 0.008580148266909,
	0.991285276176802, 0.006307942578980,
	0.996450948061849, 0.004021524171997,
	0.999326097075413, 0.001729258251298
};

const double GCoorWei_66[33][2] = {
	0.023618133385915, 0.047227481262997,
	0.070801698868133, 0.047122098287641,
	0.117827278078672, 0.046911567487618,
	0.164589938564705, 0.046596358639574,
	0.210985334548071, 0.046177175097906,
	0.256909939761528, 0.045654952225269,
	0.302261278456431, 0.045030855305431,
	0.346938154066333, 0.044306276943142,
	0.390840875016186, 0.043482833956675,
	0.433871477173377, 0.042562363770076,
	0.475933942444238, 0.041546920313245,
	0.516934413028233, 0.040438769438959,
	0.556781400851726, 0.039240383866842,
	0.595385991714136, 0.037954437665928,
	0.632662043690964, 0.036583800288146,
	0.668526379350968, 0.035131530165477,
	0.702898971358872, 0.033600867886096,
	0.735703121049507, 0.031995228964010,
	0.766865629575315, 0.030318196218832,
	0.796316961245820, 0.028573511782893,
	0.823991398695592, 0.026765068754290,
	0.849827189536017, 0.024896902514767,
	0.873766684166948, 0.022973181735367,
	0.895756464446565, 0.020998199091875,
	0.915747462945207, 0.018976361722774,
	0.933695072544792, 0.016912181472243,
	0.949559246206234, 0.014810265002710,
	0.963304586859257, 0.012675303981254,
	0.974900427746286, 0.010512065987708,
	0.984320904935140, 0.008325388765991,
	0.991545030383375, 0.006120192018431,
	0.996556821089553, 0.003901625641743,
	0.999346209872178, 0.001677653744015
};

const double GCoorWei_67[34][2] = {
	0.000000000000000, 0.046540836703564,
	0.046524035976017, 0.046490438160265,
	0.092947311252074, 0.046339351682412,
	0.139169283353515, 0.046087904489754,
	0.185089845783640, 0.045736641161063,
	0.230609544832125, 0.045286322454683,
	0.275629794969699, 0.044737923660906,
	0.320053092362531, 0.044092632489739,
	0.363783226043948, 0.043351846498685,
	0.406725486286021, 0.042517170065849,
	0.448786869719896, 0.041590410915214,
	0.489876280760653, 0.040573576201766,
	0.529904728900235, 0.039468868164306,
	0.568785521441469, 0.038278679356170,
	0.606434451255559, 0.037005587463502,
	0.642769979156620, 0.035652349722767,
	0.677713410498282, 0.034221896949544,
	0.711189065610044, 0.032717327191555,
	0.743124443704372, 0.031141899019512,
	0.773450379899983, 0.029499024470965,
	0.802101195021693, 0.027792261662423,
	0.829014837853300, 0.026025307086203,
	0.854133019537052, 0.024201987609683,
	0.877401339831656, 0.022326252196427,
	0.898769404961318, 0.020402163371315,
	0.918190936812738, 0.018433888456795,
	0.935623873270751, 0.016425690622539,
	0.951030459540145, 0.014381919827199,
	0.964377330427712, 0.012307003849272,
	0.975635583922908, 0.010205440034108,
	0.984780847755952, 0.008081790299042,
	0.991793347082310, 0.005940693177597,
	0.996658027206114, 0.003787008301817,
	0.999365435552977, 0.001628325035250
};

const double GCoorWei_68[34][2] = {
	0.022928712825430, 0.045849387387252,
	0.068737919038374, 0.045752965416067,
	0.114402568343909, 0.045560324250647,
	0.159826627277977, 0.045271869018442,
	0.204914568341940, 0.044888206345427,
	0.249571570898417, 0.044410143080353,
	0.293703720580630, 0.043838684597940,
	0.337218206795888, 0.043175032684660,
	0.380023517907669, 0.042420583011129,
	0.422029633686308, 0.041576922197386,
	0.463148214622938, 0.040645824475951,
	0.503292787709086, 0.039629247960718,
	0.542378928291009, 0.038529330529128,
	0.580324437616346, 0.037348385326164,
	0.617049515699878, 0.036088895900153,
	0.652476929144678, 0.034753510979758,
	0.686532173566014, 0.033345038903989,
	0.719143630276469, 0.031866441716797,
	0.750242716902916, 0.030320828938550,
	0.779764031618896, 0.028711451027469,
	0.807645490689710, 0.027041692545917,
	0.833828459041671, 0.025315065045178,
	0.858257873582661, 0.023535199685884,
	0.880882359017453, 0.021705839610347,
	0.901654335920109, 0.019830832087971,
	0.920530120847920, 0.017914120457947,
	0.937470018312803, 0.015959735909647,
	0.952438404479602, 0.013971789174459,
	0.965403802582199, 0.011954462319752,
	0.976338950400356, 0.009912001251563,
	0.985220861440244, 0.007848711393162,
	0.992030887742448, 0.005768969918722,
	0.996754836676664, 0.003677366595012,
	0.999383825529704, 0.001581140256364
};

const double GCoorWei_69[35][2] = {
	0.000000000000000, 0.045201602377080,
	0.045186210615097, 0.045155430236144,
	0.090280108392819, 0.045017008140394,
	0.135189569085679, 0.044786618878309,
	0.179822845240643, 0.044464733122047,
	0.224088753633998, 0.044052008465908,
	0.267896861553497, 0.043549288082916,
	0.311157671547276, 0.042957599002296,
	0.353782804262068, 0.042278150011284,
	0.395685178997243, 0.041512329185650,
	0.436779191605849, 0.040661701054076,
	0.476980889379040, 0.039728003401742,
	0.516208142556929, 0.038713143720476,
	0.554380812115137, 0.037619195311663,
	0.591420913484550, 0.036448393050672,
	0.627252775869843, 0.035203128821653,
	0.661803196841074, 0.033885946630807,
	0.695001591882934, 0.032499537409679,
	0.726780138596011, 0.031046733517912,
	0.757073915255834, 0.029530502957879,
	0.785821033446761, 0.027953943312198,
	0.812962764500296, 0.026320275416872,
	0.838443659480502, 0.024632836784517,
	0.862211662472742, 0.022895074790715,
	0.884218216947251, 0.021110539639854,
	0.904418364985826, 0.019282877128834,
	0.922770839180445, 0.017415821231968,
	0.939238147041607, 0.015513186543379,
	0.953786647805183, 0.013578860649090,
	0.966386621642862, 0.011616796610696,
	0.977012331622095, 0.009631006150427,
	0.985642080022638, 0.007625555931200,
	0.992258266716854, 0.005604579927893,
	0.996847500485195, 0.003572416739407,
	0.999401427543245, 0.001535976952795
};

const double GCoorWei_70[35][2] = {
	0.022278395286139, 0.044549417159755,
	0.066790954167560, 0.044460968417250,
	0.111170905794294, 0.044284246539052,
	0.155330137882064, 0.044019602390177,
	0.199180976364851, 0.043667561397193,
	0.242636359463741, 0.043228822505070,
	0.285610010540036, 0.042704256789447,
	0.328016609389638, 0.042094905727272,
	0.369771961638462, 0.041401979129046,
	0.410793165902624, 0.040626852736772,
	0.450998778381648, 0.039771065492777,
	0.490308974557638, 0.038836316484077,
	0.528645707679716, 0.037824461569240,
	0.565932863718808, 0.036737509693672,
	0.602096412485361, 0.035577618901317,
	0.637064554609775, 0.034347092049892,
	0.670767864094074, 0.033048372239352,
	0.703139426151534, 0.031684037961342,
	0.734114970060944, 0.030256797980160,
	0.763632996771899, 0.028769485955805,
	0.791634901007892, 0.027225054818657,
	0.818065087625442, 0.025626570908478,
	0.842871081998981, 0.023977207889106,
	0.866003634213862, 0.022280240452292,
	0.887416816863347, 0.020539037824307,
	0.907068116260923, 0.018757057093135,
	0.924918516897933, 0.016937836376283,
	0.940932579003814, 0.015084987865414,
	0.955078509114294, 0.013202190814696,
	0.967328223664987, 0.011293184649951,
	0.977657405957593, 0.009361762769726,
	0.986045558070399, 0.007411769363201,
	0.992476055211690, 0.005447111874213,
	0.996936251961680, 0.003471894893077,
	0.999418285973576, 0.001492721288847
};

const double GCoorWei_71[36][2] = {
	0.000000000000000, 0.043937284595852,
	0.043923148558139, 0.043894879211789,
	0.087761513634493, 0.043767744913398,
	0.131430475402269, 0.043556127104111,
	0.174845741028587, 0.043260434263244,
	0.217923507382456, 0.042881237157583,
	0.260580622797309, 0.042419267739609,
	0.302734747576201, 0.041875417734751,
	0.344304512929451, 0.041250736919875,
	0.385209678038525, 0.040546431097242,
	0.425371284942367, 0.039763859766850,
	0.464711810947600, 0.038904533502270,
	0.503155318268291, 0.037970111034833,
	0.540627600606487, 0.036962396051980,
	0.577056326390516, 0.035883333715631,
	0.612371178394688, 0.034735006907711,
	0.646503989470786, 0.033519632209445,
	0.679388874129645, 0.032239555623447,
	0.710962355718539, 0.030897248045055,
	0.741163488949379, 0.029495300493725,
	0.769933977541039, 0.028036419111762,
	0.797218286749317, 0.026523419942153,
	0.822963750567554, 0.024959223494325,
	0.847120673391874, 0.023346849109225,
	0.869642425956307, 0.021689409135980,
	0.890485535355208, 0.019990102932365,
	0.909609768984536, 0.018252210704700,
	0.926978212250871, 0.016479087207459,
	0.942557339922270, 0.014674155334598,
	0.956317081041052, 0.012840899668078,
	0.968230877426325, 0.010982860154284,
	0.978275736113602, 0.009103626461998,
	0.986432277268261, 0.007206835281834,
	0.992684784870641, 0.005296182844021,
	0.997021308251255, 0.003375555496730,
	0.999434442119737, 0.001451267330036
};

const double GCoorWei_72[36][2] = {
	0.021663946035422, 0.043321112165486,
	0.064951166311865, 0.043239781305226,
	0.108116447562101, 0.043077272274912,
	0.151078751482217, 0.042833890168345,
	0.193757420837032, 0.042510091910065,
	0.236072330885762, 0.042106485397589,
	0.277944039807840, 0.041623828360125,
	0.319293937846718, 0.041063026936086,
	0.360044394891415, 0.040425133971724,
	0.400118906219162, 0.039711347044835,
	0.439442236124968, 0.038923006216192,
	0.477940559168942, 0.038061591513806,
	0.515541598775996, 0.037128720154473,
	0.552174762927715, 0.036126143507638,
	0.587771276691663, 0.035055743807251,
	0.622264311339471, 0.033919530618300,
	0.655589109811197, 0.032719637064273,
	0.687683108290465, 0.031458315822546,
	0.718486053662239, 0.030137934895400,
	0.747940116632834, 0.028760973164714,
	0.775990000299983, 0.027330015738955,
	0.802583043969295, 0.025847749100685,
	0.827669322022757, 0.024316956064447,
	0.851201737654436, 0.022740510555012,
	0.873136111298781, 0.021121372216459,
	0.893431263588092, 0.019462580863309,
	0.912049092688671, 0.017767250789197,
	0.928954645880918, 0.016038564950287,
	0.944116185272539, 0.014279769054566,
	0.957505247577697, 0.012494165619852,
	0.969096697998781, 0.010685108165354,
	0.978868778557233, 0.008855996073682,
	0.986803152375831, 0.007010272321884,
	0.992884951016802, 0.005151436018782,
	0.997102871642729, 0.003283169774654,
	0.999449934452963, 0.001411516393966
};

const double GCoorWei_73[37][2] = {
	0.000000000000000, 0.042741768313924,
	0.042728755038409, 0.042702730864856,
	0.085379458949606, 0.042585689826023,
	0.127874203179614, 0.042390858992231,
	0.170135364060696, 0.042118594254250,
	0.212085744603736, 0.041769392948700,
	0.253648715511299, 0.041343892949522,
	0.294748355153842, 0.040842871502948,
	0.335309588253025, 0.040267243807565,
	0.375258323019256, 0.039618061342718,
	0.414521586492576, 0.038896509947697,
	0.453027657839947, 0.038103907655744,
	0.490706199365255, 0.037241702286359,
	0.527488384992864, 0.036311468800670,
	0.563307025990015, 0.035314906424720,
	0.598096693698278, 0.034253835545335,
	0.631793839050121, 0.033130194385056,
	0.664336908652195, 0.031946035461968,
	0.695666457223261, 0.030703521840423,
	0.725725256181560, 0.029404923180120,
	0.754458398183319, 0.028052611590536,
	0.781813397421646, 0.026649057298740,
	0.807740285502739, 0.025196824137567,
	0.832191702724914, 0.023698564864258,
	0.855122984594299, 0.022157016317033,
	0.876492243420653, 0.020574994420373,
	0.896260444846689, 0.018955389048638,
	0.914391479176256, 0.017301158762485,
	0.930852227381224, 0.015615325433577,
	0.945612621689484, 0.013900968788325,
	0.958645700697973, 0.012161220929254,
	0.969927659054985, 0.010399260994973,
	0.979437892056484, 0.008618310479547,
	0.987159036624932, 0.006821631349178,
	0.993077015588945, 0.005012538571610,
	0.997181130771611, 0.003194524377274,
	0.999464798845881, 0.001373376462751
};

const double GCoorWei_74[37][2] = {
	0.021082477516750, 0.042158706609944,
	0.063209948675108, 0.042083749969154,
	0.105225034853070, 0.041933969957777,
	0.147053034761761, 0.041709632879248,
	0.188619579744923, 0.041411137596758,
	0.229850766003721, 0.041039014824133,
	0.270673285994988, 0.040593926182209,
	0.311014558769396, 0.040076663022487,
	0.350802859017798, 0.039488145020197,
	0.389967444596249, 0.038829418539134,
	0.428438682303005, 0.038101654771267,
	0.466148171683880, 0.037306147654390,
	0.503028866645881, 0.036444311571642,
	0.539015194662810, 0.035517678836774,
	0.574043173360993, 0.034527896969821,
	0.608050524277787, 0.033476725767862,
	0.640976783590690, 0.032366034176207,
	0.672763409620242, 0.031197796965885,
	0.703353886915447, 0.029974091222494,
	0.732693826736884, 0.028697092653292,
	0.760731063758996, 0.027369071719690,
	0.787415748819575, 0.025992389600716,
	0.812700437551978, 0.024569493995976,
	0.836540174742812, 0.023102914774883,
	0.858892574265984, 0.021595259481679,
	0.879717894452088, 0.020049208702791,
	0.898979108761895, 0.018467511308973,
	0.916641971642908, 0.016852979582049,
	0.932675079462056, 0.015208484243431,
	0.947049926428386, 0.013536949411806,
	0.959740955459529, 0.011841347547506,
	0.970725604042518, 0.010124694538259,
	0.979984345431301, 0.008390045433988,
	0.987500726616238, 0.006640492909097,
	0.993261409804645, 0.004879179758610,
	0.997256261711017, 0.003109420149910,
	0.999479068780330, 0.001336761650072
};

const double GCoorWei_75[38][2] = {
	0.000000000000000, 0.041609586362141,
	0.041597580029071, 0.041573569441779,
	0.083123147002602, 0.041465581032614,
	0.124504812532900, 0.041285808082467,
	0.165670937352131, 0.041034561811385,
	0.206550255333164, 0.040712277172944,
	0.247071996864230, 0.040319512101133,
	0.287166011364304, 0.039856946544669,
	0.326762888726519, 0.039325381289620,
	0.365794079480034, 0.038725736573428,
	0.404192013461646, 0.038059050491492,
	0.441890216792342, 0.037326477200314,
	0.478823426955799, 0.036529284919277,
	0.514927705779913, 0.035668853735226,
	0.550140550125647, 0.034746673213335,
	0.584401000091579, 0.033764339818339,
	0.617649744546932, 0.032723554150962,
	0.649829223810263, 0.031626118003752,
	0.680883729296266, 0.030473931242193,
	0.710759499958046, 0.029268988515757,
	0.739404815358034, 0.028013375804791,
	0.766770085206642, 0.026709266810124,
	0.792807935213563, 0.025358919190211,
	0.817473289103545, 0.023964670653751,
	0.840723446654962, 0.022528934913900,
	0.862518157626884, 0.021054197512291,
	0.882819691447896, 0.019543011520129,
	0.901592902548447, 0.017997993125651,
	0.918805291228395, 0.016421817119040,
	0.934427059964107, 0.014817212289807,
	0.948431165079288, 0.013186956762837,
	0.960793363741892, 0.011533873328304,
	0.971492256343065, 0.009860824916133,
	0.980509324597417, 0.008170710707334,
	0.987828966767524, 0.006466464907024,
	0.993438536578892, 0.004751069185003,
	0.997328428962232, 0.003027671014600,
	0.999492775536035, 0.001301591717370
};

const double GCoorWei_76[38][2] = {
	0.020531403994004, 0.041057036916230,
	0.061559591390617, 0.040987805464796,
	0.102483975391227, 0.040849459301828,
	0.143235548227263, 0.040642231710290,
	0.183745593528908, 0.040366472122837,
	0.223945802196471, 0.040022645532592,
	0.263768387585002, 0.039611331709075,
	0.303146199807907, 0.039133224220516,
	0.342012838966961, 0.038589129264505,
	0.380302767117510, 0.037979964308419,
	0.417951418780334, 0.037306756542400,
	0.454895309813728, 0.036570641147333,
	0.491072144462188, 0.035772859380692,
	0.526420920401240, 0.034914756483541,
	0.560882031601230, 0.033997779412025,
	0.594397368836789, 0.033023474397771,
	0.626910417672260, 0.031993484340387,
	0.658366353758148, 0.030909546037519,
	0.688712135277643, 0.029773487255921,
	0.717896592387698, 0.028587223650019,
	0.745870513503610, 0.027352755531824,
	0.772586728281809, 0.026072164497981,
	0.798000187161200, 0.024747609920661,
	0.822068037328975, 0.023381325307019,
	0.844749694983342, 0.021975614534414,
	0.866006913771981, 0.020532847967896,
	0.885803849292086, 0.019055458467227,
	0.904107119545568, 0.017545937291488,
	0.920885861252149, 0.016006829912231,
	0.936111781934810, 0.014440731748259,
	0.949759207710897, 0.012850283847512,
	0.961805126758769, 0.011238168569690,
	0.972229228520377, 0.009607105414718,
	0.981013938975655, 0.007959847477226,
	0.988144453359837, 0.006299180497307,
	0.993608772723527, 0.004627935228038,
	0.997397786355355, 0.002949102953636,
	0.999505948362153, 0.001267791634091
};

const double GCoorWei_77[39][2] = {
	0.000000000000000, 0.040535835862326,
	0.040524735209115, 0.040502535726788,
	0.080982888385511, 0.040402690032222,
	0.121307986890555, 0.040236462824853,
	0.161433776694153, 0.040004127215583,
	0.201294331229941, 0.039706064931285,
	0.240824159712439, 0.039342765687580,
	0.279958314738271, 0.038914826384224,
	0.318632498994692, 0.038422950124565,
	0.356783170899782, 0.037867945060091,
	0.394347649001259, 0.037250723062883,
	0.431264214961941, 0.036572298227343,
	0.467472214962813, 0.035833785203917,
	0.502912159357244, 0.035036397367951,
	0.537525820412378, 0.034181444826117,
	0.571256327977198, 0.033270332263699,
	0.604048262920256, 0.032304556637023,
	0.635847748183315, 0.031285704713918,
	0.666602537301448, 0.030215450466603,
	0.696262100244241, 0.029095552321763,
	0.724777706436910, 0.027927850271266,
	0.752102504825211, 0.026714262849521,
	0.778191600852548, 0.025456783981730,
	0.803002130222923, 0.024157479707936,
	0.826493329329006, 0.022818484790161,
	0.848626602229624, 0.021441999205461,
	0.869365584067735, 0.020030284534329,
	0.888676200825564, 0.018585660248346,
	0.906526725321260, 0.017110499906562,
	0.922887829359401, 0.015607227268735,
	0.937732631959062, 0.014078312340035,
	0.951036743600593, 0.012526267369251,
	0.962778306467734, 0.010953642853899,
	0.972938030749109, 0.009363023692400,
	0.981499227331138, 0.007757025950076,
	0.988447838222561, 0.006138296159743,
	0.993772470949878, 0.004509523600198,
	0.997464477869214, 0.002873553083644,
	0.999518614633410, 0.001235291177130
};

const double GCoorWei_78[39][2] = {
	0.020008403124525, 0.040011465118421,
	0.059993167722210, 0.039947390369085,
	0.099881858677730, 0.039819343480365,
	0.139610597853478, 0.039627529507805,
	0.179115763260298, 0.039372255624243,
	0.218334090942214, 0.039053930627776,
	0.257202776288119, 0.038673064287269,
	0.295659574607587, 0.038230266525864,
	0.333642900810215, 0.037726246444334,
	0.371091928028598, 0.037161811185502,
	0.407946685027097, 0.036537864641681,
	0.444148152240413, 0.035855406007206,
	0.479638356288111, 0.035115528178232,
	0.514360462813861, 0.034319416002676,
	0.548258867500620, 0.033468344382890,
	0.581279285115951, 0.032563676233686,
	0.613368836445179, 0.031606860300276,
	0.644476132972788, 0.030599428837987,
	0.674551359176756, 0.029542995158635,
	0.703546352303923, 0.028439251046894,
	0.731414679498829, 0.027289964051612,
	0.758111712162313, 0.026096974655093,
	0.783594697421147, 0.024862193326252,
	0.807822826594200, 0.023587597461445,
	0.830757300545913, 0.022275228219128,
	0.852361391822554, 0.020927187251840,
	0.872600503472725, 0.019545633343404,
	0.891442224458821, 0.018132778955018,
	0.908856381573186, 0.016690886689309,
	0.924815087780066, 0.015222265680211,
	0.939292786914948, 0.013729267920168,
	0.952266294689863, 0.012214284549775,
	0.963714835986756, 0.010679742157484,
	0.973620078506237, 0.009128099227276,
	0.981966163099550, 0.007561843189437,
	0.988739732093718, 0.005983489944451,
	0.993929961694489, 0.004395596039449,
	0.997528638378725, 0.002800868811853,
	0.999530799992424, 0.001204024566071
};

const double GCoorWei_79[40][2] = {
	0.000000000000000, 0.039516107256271,
	0.039505823435979, 0.039485257401292,
	0.078949963218956, 0.039392756004744,
	0.118270832007652, 0.039238747496588,
	0.157407034933870, 0.039023472342888,
	0.196297465463179, 0.038747266670233,
	0.234881400805730, 0.038410561741102,
	0.273098596727519, 0.038013883280318,
	0.310889381614739, 0.037557850654335,
	0.348194749643873, 0.037043175904058,
	0.384956452912354, 0.036470662633160,
	0.421117092385773, 0.035841204753350,
	0.456620207519688, 0.035155785088609,
	0.491410364416127, 0.034415473840702,
	0.525433242377053, 0.033621426918025,
	0.558635718719854, 0.032774884131108,
	0.590965951722135, 0.031877167256588,
	0.622373461566578, 0.030929677973529,
	0.652809209159343, 0.029933895674834,
	0.682225672699070, 0.028891375157600,
	0.710576921876822, 0.027803744195433,
	0.737818689591277, 0.026672700997098,
	0.763908441067165, 0.025500011555095,
	0.788805440269197, 0.024287506888792,
	0.812470813507809, 0.023037080185736,
	0.834867610137776, 0.021750683846591,
	0.855960860255221, 0.020430326438156,
	0.875717629303529, 0.019078069558929,
	0.894107069504238, 0.017696024624344,
	0.911100468034580, 0.016286349576187,
	0.926671291880903, 0.014851245526337,
	0.940795229306577, 0.013392953344827,
	0.953450227889269, 0.011913750215113,
	0.964616529114864, 0.010415946204497,
	0.974276699597808, 0.008901880982671,
	0.982415659251279, 0.007373921131338,
	0.989020707687784, 0.005834459868746,
	0.994081554785543, 0.004285929113126,
	0.997590394336941, 0.002730907065742,
	0.999542528479570, 0.001173930129949
};

const double GCoorWei_80[40][2] = {
	0.019511383256788, 0.039017813656306,
	0.058504437152419, 0.038958395962769,
	0.097408398441586, 0.038839651059053,
	0.136164022809136, 0.038661759774069,
	0.174712291832638, 0.038424993006950,
	0.212994502857670, 0.038129711314482,
	0.250952358392272, 0.037776364362001,
	0.288528054884507, 0.037365490238720,
	0.325664370747706, 0.036897714638285,
	0.362304753499494, 0.036373749905852,
	0.398393405881963, 0.035794393953400,
	0.433875370831749, 0.035160529044727,
	0.468696615170550, 0.034473120451773,
	0.502804111888783, 0.033733214984606,
	0.536145920897134, 0.032941939397654,
	0.568671268122709, 0.032100498673483,
	0.600330622829752, 0.031210174188117,
	0.631075773046877, 0.030272321759581,
	0.660859898986125, 0.029288369583296,
	0.689637644342030, 0.028259816057294,
	0.717365185362105, 0.027188227500517,
	0.744000297583596, 0.026075235767558,
	0.769502420135045, 0.024922535764142,
	0.793832717504605, 0.023731882865927,
	0.816954138681460, 0.022505090246302,
	0.838831473580256, 0.021244026115789,
	0.859431406663114, 0.019950610878173,
	0.878722567678217, 0.018626814208331,
	0.896675579438768, 0.017274652056238,
	0.913263102571758, 0.015896183583736,
	0.928459877172447, 0.014493508040522,
	0.942242761309873, 0.013068761592410,
	0.954590766343635, 0.011624114120794,
	0.965485089043800, 0.010161766041113,
	0.974909140585728, 0.008683945269266,
	0.982848572738629, 0.007192904768112,
	0.989291302499756, 0.005690922451402,
	0.994227540965688, 0.004180313124704,
	0.997649864398238, 0.002663533589511,
	0.999553822651631, 0.001144950003182
};

// logarithmic singula Gauss integral between [0, 1]: I = int[0, 1] ln(1/x) f(x) dx;
// see A.3.1 and Table A.3 in C. A. Brebbia et al. "Boundary Element Techniques",
// Springer Verlag 1984 
const double LnCoorWei_2[2][2] = {
	0.11200880, 0.71853931,
	0.60227691, 0.28146068
};

const double LnCoorWei_3[3][2] = {
	0.063890792, 0.51340455,
	0.36899706, 0.39198004,
	0.76688030, 0.094615406
};

const double LnCoorWei_4[4][2] = {
	0.041448480, 0.38346406,
	0.24527491, 0.38687532,
	0.55616545, 0.19043513,
	0.84898239, 0.039225487
};

const double LnCoorWei_5[5][2] = {
	0.029134472, 0.29789346,
	0.17397721, 0.34977622,
	0.41170251, 0.23448829,
	0.67731417, 0.098930460,
	0.89477136, 0.018911552
};

const double LnCoorWei_6[6][2] = {
	0.021634005, 0.23876366,
	0.12958339, 0.30828657,
	0.31402045, 0.24531742,
	0.53865721, 0.14200875,
	0.75691533, 0.055454622,
	0.92266884, 0.010168958
};

const double LnCoorWei_7[7][2] = {
	0.016719355, 0.19616938,
	0.10018568, 0.27030264,
	0.24629424, 0.23968187,
	0.43346349, 0.16577577,
	0.63235098, 0.088943226,
	0.81111862, 0.033194304,
	0.94084816, 0.0059327869
};

const double LnCoorWei_8[8][2] = {
	0.013320243, 0.16441660,
	0.079750427, 0.23752560,
	0.19787102, 0.22684198,
	0.35415398, 0.17575408,
	0.52945857, 0.11292402,
	0.70181452, 0.057872212,
	0.84937932, 0.020979074,
	0.95332645, 0.0036864071
};

const double LnCoorWei_9[9][2] = {
	0.010869338, 0.14006846,
	0.064983682, 0.20977224,
	0.16222943, 0.21142716,
	0.29374996, 0.17715622,
	0.44663195, 0.12779920,
	0.60548172, 0.078478879,
	0.75411017, 0.039022490,
	0.87726585, 0.013867290,
	0.96225056, 0.0024080402
};

const double LnCoorWei_10[10][2] = {
	0.0090425944, 0.12095474,
	0.053971054, 0.18636310,
	0.13531134, 0.19566066,
	0.24705169, 0.17357723,
	0.38021171, 0.13569597,
	0.52379159, 0.093647084,
	0.66577472, 0.055787938,
	0.79419019, 0.027159893,
	0.89816102, 0.0095151992,
	0.96884798, 0.0016381586
};

const double LnCoorWei_12[12][2] = 
{
	0.0065487222790800587893, 0.093192691443931324634,
	0.038946809560449959162, 0.14975182757632236407, 
	0.098150263106006628862, 0.16655745436459300525,
	0.18113858159063157735, 0.15963355943698765119,
	0.28322006766737255470, 0.13842483186483562107,
	0.39843443516343664370, 0.11001657063572116235,
	0.51995262679235266273, 0.079961821770828970270,
	0.64051091671610645430, 0.052406954824641770655, 
	0.75286501205183057837, 0.030071088873761187127,
	0.85024002416230220067, 0.014249245587998279104,
	0.92674968322391410105, 0.0048999245823217609349,
	0.97775612968999747917, 0.00083402903805690336423
};

const double LnCoorWei_14[14][2] = 
{
	0.0049660035738685422439, 0.074291225067510413727,
	0.029432540118885178287, 0.12298877246932291436,
	0.074376292224535762610, 0.14219930656252335576, 
	0.13813849198918628180, 0.14322929764126422200,
	0.21805564849895907807, 0.13234508377208520930,
	0.31066208391810198318, 0.11413587573667647524,
	0.41187247517775020721, 0.092283038079073613224,
	0.51717930739865432972, 0.069753673293937564554,
	0.62186485972851111971, 0.048830323600513564645,
	0.72122074520810885374, 0.031101796064416141114,
	0.81076598807158985636, 0.017462811950196093829, 
	0.88645403803443465719, 0.0081424234298759361327,
	0.94485913946181863893, 0.0027684364185639373293,
	0.98333102648567848005, 0.00046793591404056013463
};

const double LnCoorWei_16[16][2] = 
{
	0.0038978344871159159241, 0.060791710043591231808,
	0.023028945616873239820, 0.10291567751758214463, 
	0.058280398306240412348, 0.12235566204600919376, 
	0.10867836509105403649, 0.12756924693701598865,
	0.17260945490984393776, 0.12301357460007091537, 
	0.24793705447057849515, 0.11184724485548572262,
	0.33209454912991715598, 0.096596385152124341273,
	0.42218391058194860012, 0.079356664351473138795,
	0.51508247338146260348, 0.061850494581965207089,
	0.60755612044772872409, 0.045435246507726668623,
	0.69637565322821406116, 0.031098974751581806404,
	0.77843256587326540520, 0.019459765927360842075,
	0.85085026971539108323, 0.010776254963205525645,
	0.91108685722227190542, 0.0049725428900876417092, 
	0.95702557170354215759, 0.0016782011100511945144,
	0.98704780024798447676, 0.00028235376466843632024
};

const double LnCoorWei_18[18][2] = 
{
	0.0031424651380014529463, 0.050784756915023180947,
	0.018513312208084287912, 0.087491821769871031501,
	0.046889182995356774082, 0.1062319870724270878,
	0.087668179177975146725, 0.11360096280311896174,
	0.13982127438539053378, 0.11294042101485767893,
	0.20196630657019948548, 0.10654092905456052026,
	0.27242025550071137741, 0.096207803256969010875,
	0.34925253866262540422, 0.083449252414309202929,
	0.43034258855914332433, 0.069542279492201344550,
	0.51344160043931639749, 0.055552507752692763805,
	0.59623730851953265078, 0.042336679719951225028,
	0.67642023263221360199, 0.030540545134394263842,
	0.75174965504183758161, 0.020598370412719446231,
	0.82011752690582441429, 0.012737251354385464069,
	0.87960852289318394155, 0.0069877593795258261240,
	0.92855452882989728908, 0.0032014357114096158649,
	0.96558185199283227534, 0.0010749552656355749981,
	0.98964823849716613563, 0.00018028147594780068227
};

const double LnCoorWei_20[20][2] = 
{
	0.0025883279559219554283, 0.043142752133208078953,
	0.015209662349560231721, 0.075383709908589360324,
	0.038536550372165327960, 0.093053267451663051484,
	0.072181613815873906435, 0.10145671184982975438,
	0.11546052648763315056, 0.10320176205607206901,
	0.16744285627532968572, 0.10002254980527316660, 
	0.22698378726020250336, 0.093259799300297678097,
	0.29275496094154583299, 0.084028952871941056497,
	0.36327742985785890454, 0.073285589130030740963,
	0.43695714009076831849, 0.061850336913730289952,
	0.51212259467896733620, 0.050416604438374677634,
	0.58706404491440991513, 0.039551370005298385329,
	0.66007341331490941391, 0.029694077895812844809,
	0.72948408392968749887, 0.021156315355427097677,
	0.79370967198708581774, 0.014123732938964020441,
	0.85128089278912572722, 0.0086609745043354986299,
	0.90087968085441759422, 0.0047199401462036049505,
	0.94136974912909167630, 0.0021513974039652061137, 
	0.97182274107526319374, 0.00071972821465320264468,
	0.99153808143871197265, 0.00012042767633021674146
};

const double LnCoorWei_22[22][2] = 
{
	0.0021695949803285638149, 0.037163043138592130230,
	0.012719648971152510485, 0.065699316559448469687,
	0.032232015260524765680, 0.082185491301408608728, 
	0.060449207337674319109, 0.090991586882468694731,
	0.096900185220601655561, 0.094216388483819804084,
	0.14093739577045211674, 0.093219458131013617422,
	0.19175734783119957800, 0.089030831157155025608, 
	0.24841954195362504641, 0.082499058803798538956,
	0.30986633772463128209, 0.074352380330871826382,
	0.37494431115786080794, 0.065224879320135427415,
	0.44242706636642338680, 0.055666984197486033713,
	0.51103923650231173868, 0.046148767580656176031, 
	0.57948130102149223055, 0.037060187168458089601,
	0.64645479036869572408, 0.028710478651216795349,
	0.71068742094630257475, 0.021327949036556005923,
	0.77095769304535272672, 0.015060891293331557262,
	0.82611848779591564125, 0.0099800241077423651729,
	0.87511921339628865437, 0.0060826526502991242745,
	0.91702607250558593318, 0.0032985992326508043741, 
	0.95104004074243233726, 0.0014978425302842379688,
	0.97651209250375637626, 0.00049971850684916309727,
	0.99295430859449355338, 0.000083470935757501809464
};

const double LnCoorWei_24[24][2] = 
{
	0.0018453608220336759243, 0.032388233873295456332,
	0.010796162815989972325, 0.057826563715813965670,
	0.027357452961246117020, 0.073136328686516981091,
	0.051353591299404972043, 0.081985615732144319312,
	0.082450873021720622270, 0.086105031333835726689,
	0.12018574140382190931, 0.086591103031372074161,
	0.16397890448999139944, 0.084258538331342485480,
	0.21314756641797254994, 0.079770134424991065129,
	0.26691796474303598084, 0.073692502565397697493,
	0.32443876570791464897, 0.066521540481183118932,
	0.38479540284525942454, 0.058694018053608477883,
	0.44702526657212612674, 0.050592392668453691805,
	0.51013357010621753127, 0.042546323036692874159,
	0.57310967366952803683, 0.034832727086785794308,
	0.63494362483092577818, 0.027675433011390150695, 
	0.69464266014454743552, 0.021245046769959996004,
	0.75124740850958010592, 0.015659412822653511903,
	0.80384753819496798775, 0.010984890711271193073,
	0.85159659619612663656, 0.0072385663845339534898,
	0.89372579950307613662, 0.0043914426594726389590,
	0.92955655081116447498, 0.0023725967734820588501,
	0.95851145740813343977, 0.0010742486277244498128,
	0.98012357419738178213, 0.00035764789614588879903,
	0.99404281450493906845, 0.000059661321932428648318
};

const double LnCoorWei_26[26][2] = 
{
	0.0015891060428450550662, 0.028509592361949552649,
	0.0092793053768192179149, 0.051335115175179411146,
	0.023511205362465350489, 0.065529137388970749327,
	0.044162476616391857622, 0.074218046991249630077,
	0.070990869364339218373, 0.078856763155975640900,
	0.10365645045814307078, 0.080350306187290315270,
	0.14173175744227596049, 0.079359169586291632105,
	0.18471006647271133039, 0.076413501995065351614,
	0.23201363019087279382, 0.071963306265620773915,
	0.28300239224278726990, 0.066402372992380112137,
	0.33698330609888246806, 0.060079981728480176081,
	0.39322024410325499997, 0.053306455931430598600,
	0.45094441832462206379, 0.046355526106784113926,
	0.50936520116247405885, 0.039465066358826455468,
	0.56768121447659903198, 0.032837092695156727820,
	0.62509154478027444434, 0.026637554500747163189,
	0.68080693593076308338, 0.020996248487343493551,
	0.73406080841168199211, 0.016007062001846595726,
	0.78411995501788583483, 0.011728673415255544128,
	0.83029476608521797736, 0.0081857828191622350424,
	0.87194884297974799532, 0.0053709065403394571160,
	0.90850786580251794214, 0.0032467386148271657177,
	0.93946758854291712264, 0.0017490582907739274103,
	0.96440083487455656959, 0.00079014312617055648275,
	0.98296331159922741347, 0.00026263140332801338699,
	0.99489738326702046713, 0.000043765879554607677559
};

const double LnCoorWei_28[28][2] = 
{
	0.0013830188064882147702, 0.025312267717508830007,
	0.0080618915504578894369, 0.045915574341536648161,
	0.020423215085321764651, 0.059075934672171799433,
	0.038380365583054858941, 0.067492085448055009451,
	0.061753771397849785973, 0.072406599347343368319,
	0.090288914303517229825, 0.074580710797395840865,
	0.12366392798121565905, 0.074561171918644513458,
	0.16149541341280556948, 0.072781002449444609979,
	0.20334405018679542935, 0.069604539637103787357,
	0.24872045433041165482, 0.065349529763165328318,
	0.29709141941481538843, 0.060298436660616663346, 
	0.34788656199313256238, 0.054704239154232612519,
	0.40050534085266238418, 0.048793269467366570004,
	0.45432439304124739336, 0.042766439561443504326,
	0.50870511450348610948, 0.036799617280712231241,
	0.56300140400392379947, 0.031043607834706182874,
	0.61656748344367950687, 0.025624024863368506690,
	0.66876570456855570356, 0.020641233599436593443,
	0.71897425084775552319, 0.016170484634337655039,
	0.76659464365581130149, 0.012262314191514997357,
	0.81105896361653173115, 0.0089432568787655219960,
	0.85183670090751973156, 0.0062168947811803217204,
	0.88844115228415883424, 0.0040652497012454670498,
	0.92043528715986368671, 0.0024505117390088140068,
	0.94743700893607184477, 0.0013170862800129159244, 
	0.96912373461643381516, 0.00059393226235832484280,
	0.98523616335581453552, 0.00019715705294287550469,
	0.99558051719158484892, 0.000032827964380508278314
};

// Gauss-Laguerre Abscissas and weights for Int(0, inf)  exp(-x) f(x) dx
const double GauLagAbscWei_12[12][2] =
{
	1.15722117358e-001, 2.64731371055e-001,
	6.11757484515e-001, 3.77759275873e-001,
	1.51261026978e+000, 2.44082011320e-001,
	2.83375133774e+000, 9.04492222117e-002,
	4.59922763942e+000, 2.01023811546e-002,
	6.84452545312e+000, 2.66397354187e-003,
	9.62131684246e+000, 2.03231592663e-004,
	1.30060549933e+001, 8.36505585682e-006,
	1.71168551875e+001, 1.66849387654e-007,
	2.21510903794e+001, 1.34239103052e-009,
	2.84879672510e+001, 3.06160163504e-012,
	3.70991210445e+001, 8.14807746743e-016
};
const double GauLagAbscWei_14[14][2] =
{
	9.97475070326e-002, 2.31815577145e-001,
	5.26857648852e-001, 3.53784691598e-001,
	1.30062912125e+000, 2.58734610245e-001,
	2.43080107873e+000, 1.15482893557e-001,
	3.93210282229e+000, 3.31920921593e-002,
	5.82553621830e+000, 6.19286943701e-003,
	8.14024014157e+000, 7.39890377867e-004,
	1.09164995074e+001, 5.49071946684e-005,
	1.42108050112e+001, 2.40958576409e-006,
	1.81048922202e+001, 5.80154398168e-008,
	2.27233816283e+001, 6.81931469248e-010,
	2.82729817232e+001, 3.22120775189e-012,
	3.51494436606e+001, 4.22135244052e-015,
	4.43660817111e+001, 6.05237502229e-019
};
const double GauLagAbscWei_16[16][2] =
{
	8.76494104789e-002, 2.06151714958e-001,
	4.62696328915e-001, 3.31057854951e-001,
	1.14105777483e+000, 2.65795777644e-001,
	2.12928364510e+000, 1.36296934296e-001,
	3.43708663389e+000, 4.73289286941e-002,
	5.07801861455e+000, 1.12999000803e-002,
	7.07033853505e+000, 1.84907094353e-003,
	9.43831433639e+000, 2.04271915308e-004,
	1.22142233689e+001, 1.48445868740e-005,
	1.54415273688e+001, 6.82831933087e-007,
	1.91801568568e+001, 1.88102484108e-008,
	2.35159056940e+001, 2.86235024297e-010,
	2.85787297429e+001, 2.12707903322e-012,
	3.45833987023e+001, 6.29796700252e-015,
	4.19404526477e+001, 5.05047370004e-018,
	5.17011603395e+001, 4.16146237037e-022
};
const double GauLagAbscWei_20[20][2] =
{
	7.05398896920e-002, 1.68746801851e-001,
	3.72126818002e-001, 2.91254362006e-001,
	9.16582102483e-001, 2.66686102867e-001,
	1.70730653103e+000, 1.66002453270e-001,
	2.74919925531e+000, 7.48260646688e-002,
	4.04892531385e+000, 2.49644173093e-002,
	5.61517497086e+000, 6.20255084457e-003,
	7.45901745367e+000, 1.14496238648e-003,
	9.59439286958e+000, 1.55741773028e-004,
	1.20388025470e+001, 1.54014408652e-005,
	1.48142934426e+001, 1.08648636652e-006,
	1.79488955205e+001, 5.33012090956e-008,
	2.14787882403e+001, 1.75798117905e-009,
	2.54517027932e+001, 3.72550240251e-011,
	2.99325546317e+001, 4.76752925158e-013,
	3.50134342405e+001, 3.37284424336e-015,
	4.08330570567e+001, 1.15501433950e-017,
	4.76199940473e+001, 1.53952214058e-020,
	5.58107957501e+001, 5.28644272557e-024,
	6.65244165256e+001, 1.65645661250e-028
};
const double GauLagAbscWei_24[24][2] =
{
	5.90198521815e-002, 1.42811973335e-001,
	3.11239146198e-001, 2.58774107517e-001,
	7.66096905546e-001, 2.58806707273e-001,
	1.42559759080e+000, 1.83322688978e-001,
	2.29256205863e+000, 9.81662726299e-002,
	3.37077426421e+000, 4.07324781514e-002,
	4.66508370347e+000, 1.32260194051e-002,
	6.18153511874e+000, 3.36934905848e-003,
	7.92753924717e+000, 6.72162564094e-004,
	9.91209801508e+000, 1.04461214659e-004,
	1.21461027117e+001, 1.25447219780e-005,
	1.46427322896e+001, 1.15131581274e-006,
	1.74179926465e+001, 7.96081295913e-008,
	2.04914600826e+001, 4.07285898755e-009,
	2.38873298482e+001, 1.50700822629e-010,
	2.76359371743e+001, 3.91773651506e-012,
	3.17760413524e+001, 6.89418105296e-014,
	3.63584058017e+001, 7.81980038246e-016,
	4.14517204849e+001, 5.35018881301e-018,
	4.71531064452e+001, 2.01051746456e-020,
	5.36085745447e+001, 3.60576586455e-023,
	6.10585314472e+001, 2.45181884588e-026,
	6.99622400351e+001, 4.08830159368e-030,
	8.14982792339e+001, 5.57534578833e-035
};
const double GauLagAbscWei_32[32][2] =
{
	0.0444893658333, 0.109218341952,
	0.23452610952,  0.210443107939,
	0.576884629302, 0.23521322967,
	1.07244875382,  0.195903335972,
	1.72240877644,  0.129983786299,
	2.52833670643,  0.0705786238336,
	3.49221327285,  0.0317609125169,
	4.61645677223,  0.011918214131,
	5.90395848335,  0.00373881741251,
	7.3581268086,   0.000980802405686,
	8.98294126732,  0.000214868183409,
	10.783012089,   3.9206599847e-005,
	12.763745476,   5.93491584325e-006,
	14.9309117981,  7.42725633002e-007,
	17.2932661372,  7.62644877602e-008,
	19.8536236493,  6.30626997915e-009,
	22.6357789624,  4.08362052082e-010,
	25.6201482024,  2.41193908639e-011,
	28.8739336869,  8.42600236462e-013,
	32.3333294017,  3.98620503719e-014,
	36.1132042245,  8.86310247569e-016,
	40.1337377056,  1.93438784581e-017,
	44.5224085362,  2.36023435352e-019,
	49.2086605665,  1.7684205425e-021,
	54.3501813324,  1.54277824262e-023,
	59.8791192845,  5.28465797982e-026,
	65.9833617042,  1.38670562699e-028,
	72.6842683222,  1.87054245572e-031,
	80.1883747906,  1.18414925494e-034,
	88.735192639,   2.67172178868e-038,
	98.8295523148,  1.33869185345e-042,
	111.751398227,  4.51055359187e-048
};
const double GauLagAbscWei_40[40][2] =
{
	3.57003943089e-002, 8.84121061904e-002,
	1.88162283159e-001, 1.76814739096e-001,
	4.62694281315e-001, 2.11363117016e-001,
	8.59772963973e-001, 1.94081195319e-001,
	1.38001082053e+000, 1.46434282424e-001,
	2.02420913592e+000, 9.33267984358e-002,
	2.79336935351e+000, 5.09322043610e-002,
	3.68870267791e+000, 2.39761930157e-002,
	4.71164114655e+000, 9.77462524671e-003,
	5.86385087834e+000, 3.45793999302e-003,
	7.14724790810e+000, 1.06224689390e-003,
	8.56401701759e+000, 2.83271685324e-004,
	1.01166340485e+001, 6.55094050032e-005,
	1.18078922940e+001, 1.31160690733e-005,
	1.36409337125e+001, 2.26845287878e-006,
	1.56192858933e+001, 3.37962648220e-007,
	1.77469059501e+001, 4.32282132228e-008,
	2.00282328346e+001, 4.72849377099e-009,
	2.24682499835e+001, 4.40317410423e-010,
	2.50725607724e+001, 3.47244148480e-011,
	2.78474800092e+001, 2.30538154492e-012,
	3.08001457394e+001, 1.27977259768e-013,
	3.39386570849e+001, 5.89417717235e-015,
	3.72722458805e+001, 2.23221757990e-016,
	4.08114928239e+001, 6.88033648428e-018,
	4.45686031753e+001, 1.70560373682e-019,
	4.85577635331e+001, 3.35371194067e-021,
	5.27956111872e+001, 5.14619956014e-023,
	5.73018633234e+001, 6.04476251159e-025,
	6.21001790728e+001, 5.31058477732e-027,
	6.72193709271e+001, 3.39252805328e-029,
	7.26951588476e+001, 1.52173549318e-031,
	7.85728029116e+001, 4.58529161450e-034,
	8.49112311357e+001, 8.76215865749e-037,
	9.17898746712e+001, 9.82741572515e-040,
	9.93208087174e+001, 5.80115201917e-043,
	1.07672440639e+002, 1.53090868461e-046,
	1.17122309513e+002, 1.38198630565e-050,
	1.28201841988e+002, 2.56663360501e-055,
	1.42280044469e+002, 2.70036094022e-061
};
const double GauLagAbscWei_50[50][2] =
{
	2.86305183394e-002, 7.14047261352e-002,
	1.50882935677e-001, 1.47148606965e-001,
	3.70948781535e-001, 1.85671627575e-001,
	6.89090699881e-001, 1.84385382527e-001,
	1.10562502354e+000, 1.54201168606e-001,
	1.62096175110e+000, 1.11685369902e-001,
	2.23561037592e+000, 7.10528854902e-002,
	2.95018336664e+000, 4.00202769115e-002,
	3.76539977441e+000, 2.00506230801e-002,
	4.68208938756e+000, 8.96085120365e-003,
	5.70119757478e+000, 3.57811241532e-003,
	6.82379090979e+000, 1.27761715679e-003,
	8.05106366939e+000, 4.08030244984e-004,
	9.38434530826e+000, 1.16528832231e-004,
	1.08251090315e+001, 2.97417049369e-005,
	1.23749816088e+001, 6.77784252654e-006,
	1.40357545998e+001, 1.37747950317e-006,
	1.58093971978e+001, 2.49288618172e-007,
	1.76980709334e+001, 4.01035435043e-008,
	1.97041465355e+001, 5.72333174814e-009,
	2.18302233066e+001, 7.22943424918e-010,
	2.40791514444e+001, 8.06171014228e-011,
	2.64540578413e+001, 7.91339309994e-012,
	2.89583760119e+001, 6.81573661768e-013,
	3.15958809566e+001, 5.13242671659e-014,
	3.43707299631e+001, 3.36562476244e-015,
	3.72875106106e+001, 1.91347632697e-016,
	4.03512975736e+001, 9.38558978183e-018,
	4.35677202700e+001, 3.95006996450e-019,
	4.69430439916e+001, 1.41774951783e-020,
	5.04842679631e+001, 4.30997027629e-022,
	5.41992448802e+001, 1.10125751985e-023,
	5.80968280172e+001, 2.34461775561e-025,
	6.21870541757e+001, 4.11854415464e-027,
	6.64813738784e+001, 5.90224676360e-029,
	7.09929448266e+001, 6.81200891655e-031,
	7.57370115477e+001, 6.23744949881e-033,
	8.07314048025e+001, 4.45244057968e-035,
	8.59972111365e+001, 2.42686235225e-037,
	9.15596904125e+001, 9.85297148105e-040,
	9.74495656149e+001, 2.89107887232e-042,
	1.03704891237e+002, 5.90616270811e-045,
	1.10373858808e+002, 8.01287459750e-048,
	1.17519198203e+002, 6.78957542440e-051,
	1.25225470133e+002, 3.30817301085e-054,
	1.33612027923e+002, 8.25096487644e-058,
	1.42858325489e+002, 8.84872812830e-062,
	1.53260371973e+002, 3.06489488984e-066,
	1.65385643317e+002, 1.98870822933e-071,
	1.80698343709e+002, 6.04956715224e-078
};
const double GauLagAbscWei_60[60][2] =
{
	2.38979772627e-002, 5.98836115238e-002,
	1.25934718882e-001, 1.25910967075e-001,
	3.09578934327e-001, 1.64730789082e-001,
	5.74995542093e-001, 1.72391187327e-001,
	9.22369482117e-001, 1.54429268002e-001,
	1.35193836001e+000, 1.21803513026e-001,
	1.86399634430e+000, 8.58079768798e-002,
	2.45889584382e+000, 5.44353672265e-002,
	3.13704900979e+000, 3.12527897522e-002,
	3.89892938720e+000, 1.62902590476e-002,
	4.74507380013e+000, 7.72474566051e-003,
	5.67608450825e+000, 3.33668949431e-003,
	6.69263166279e+000, 1.31386586345e-003,
	7.79545608903e+000, 4.71788726106e-004,
	8.98537242566e+000, 1.54500736346e-004,
	1.02632726550e+001, 4.61336302915e-005,
	1.16301300638e+001, 1.25555415864e-005,
	1.30870036794e+001, 3.11265361167e-006,
	1.46350432340e+001, 7.02389231692e-007,
	1.62754947192e+001, 1.44139423387e-007,
	1.80097065989e+001, 2.68711553825e-008,
	1.98391367654e+001, 4.54532404657e-009,
	2.17653603344e+001, 6.96674608705e-010,
	2.37900783895e+001, 9.66111905165e-011,
	2.59151278116e+001, 1.21013729020e-011,
	2.81424923461e+001, 1.36665089718e-012,
	3.04743150937e+001, 1.38875835687e-013,
	3.29129126441e+001, 1.26704409274e-014,
	3.54607911123e+001, 1.03541838501e-015,
	3.81206643939e+001, 7.55907205834e-017,
	4.08954750148e+001, 4.91605568324e-018,
	4.37884180359e+001, 2.83933159578e-019,
	4.68029685719e+001, 1.45143796450e-020,
	4.99429136103e+001, 6.54273502009e-022,
	5.32123889826e+001, 2.59025190968e-023,
	5.66159225427e+001, 8.96642784354e-025,
	6.01584848845e+001, 2.70067800928e-026,
	6.38455492795e+001, 7.03988949156e-028,
	6.76831629871e+001, 1.57875478538e-029,
	7.16780327144e+001, 3.02587768946e-031,
	7.58376278547e+001, 4.92016735526e-033,
	8.01703062926e+001, 6.73166411605e-035,
	8.46854691945e+001, 7.67809653883e-037,
	8.93937534903e+001, 7.22466942401e-039,
	9.43072740661e+001, 5.54150039836e-041,
	9.94399325429e+001, 3.41766012791e-043,
	1.04807816807e+002, 1.66814952204e-045,
	1.10429726687e+002, 6.32557327160e-048,
	1.16327878898e+002, 1.82313963858e-050,
	1.22528873384e+002, 3.89065966922e-053,
	1.29065052185e+002, 5.95516154577e-056,
	1.35976468604e+002, 6.28544922615e-059,
	1.43313845260e+002, 4.35239524004e-062,
	1.51143216696e+002, 1.85335648499e-065,
	1.59553625239e+002, 4.44827348304e-069,
	1.68670806549e+002, 5.32256631496e-073,
	1.78683925013e+002, 2.64120678052e-077,
	1.89905246962e+002, 4.01650584255e-082,
	2.02933987950e+002, 1.05169410392e-087,
	2.19318115774e+002, 1.09094194862e-094
};
const double GauLagAbscWei_70[70][2] =
{
	2.05080768555e-002, 5.15632430121e-002,
	1.08067020256e-001, 1.09989501626e-001,
	2.65637946603e-001, 1.47682124153e-001,
	4.93334227080e-001, 1.60459689802e-001,
	7.91273659821e-001, 1.50986954431e-001,
	1.15960621770e+000, 1.26569043218e-001,
	1.59851703948e+000, 9.58957008251e-002,
	2.10822742457e+000, 6.62153733165e-002,
	2.68899558063e+000, 4.18833485417e-002,
	3.34111739588e+000, 2.43501025119e-002,
	4.06492730048e+000, 1.30409625385e-002,
	4.86079923959e+000, 6.44354278630e-003,
	5.72914777049e+000, 2.94025044372e-003,
	6.67042929386e+000, 1.23984857026e-003,
	7.68514342913e+000, 4.83324191389e-004,
	8.77383454464e+000, 1.74205280573e-004,
	9.93709345470e+000, 5.80534943765e-005,
	1.11755592970e+001, 1.78841078211e-005,
	1.24899216057e+001, 5.09155452598e-006,
	1.38809225974e+001, 1.33906236043e-006,
	1.53493596894e+001, 3.25159513748e-007,
	1.68960882737e+001, 7.28573005021e-008,
	1.85220247697e+001, 1.50530959399e-008,
	2.02281499868e+001, 2.86556604084e-009,
	2.20155128280e+001, 5.02161471421e-010,
	2.38852343730e+001, 8.09285762819e-011,
	2.58385123829e+001, 1.19818280532e-011,
	2.78766262750e+001, 1.62780695432e-012,
	3.00009426262e+001, 2.02672408425e-013,
	3.22129212678e+001, 2.30944136552e-014,
	3.45141220476e+001, 2.40492520845e-015,
	3.69062123472e+001, 2.28502310747e-016,
	3.93909754547e+001, 1.97757612702e-017,
	4.19703199121e+001, 1.55608063296e-018,
	4.46462899757e+001, 1.11103877177e-019,
	4.74210773531e+001, 7.18291972884e-021,
	5.02970344104e+001, 4.19520303355e-022,
	5.32766890771e+001, 2.20807311179e-023,
	5.63627617242e+001, 1.04454337634e-024,
	5.95581843425e+001, 4.42836903881e-026,
	6.28661224151e+001, 1.67731857966e-027,
	6.62899999662e+001, 5.65691465013e-029,
	6.98335283670e+001, 1.69258077240e-030,
	7.35007396198e+001, 4.47506750850e-032,
	7.72960250047e+001, 1.04099756029e-033,
	8.12241801968e+001, 2.12053200426e-035,
	8.52904582398e+001, 3.76298879472e-037,
	8.95006321349e+001, 5.78413097379e-039,
	9.38610692929e+001, 7.65294967049e-041,
	9.83788207520e+001, 8.65525294014e-043,
	1.03061728951e+002, 8.30281898066e-045,
	1.07918559065e+002, 6.69738065071e-047,
	1.12959160615e+002, 4.49874788779e-049,
	1.18194668445e+002, 2.48890520508e-051,
	1.23637755651e+002, 1.12000257975e-053,
	1.29302956094e+002, 4.04102187826e-056,
	1.35207081802e+002, 1.14978895645e-058,
	1.41369772265e+002, 2.53037452387e-061,
	1.47814231263e+002, 4.20973184553e-064,
	1.54568237161e+002, 5.15156274407e-067,
	1.61665564004e+002, 4.48534535558e-070,
	1.69148041496e+002, 2.66657945108e-073,
	1.77068650456e+002, 1.02755723051e-076,
	1.85496382761e+002, 2.39855603294e-080,
	1.94524300380e+002, 3.09597194294e-084,
	2.04283872295e+002, 1.94331975014e-088,
	2.14972993893e+002, 4.89150580401e-093,
	2.26918553810e+002, 3.59530484974e-098,
	2.40748309834e+002, 4.21330305934e-104,
	2.58085501530e+002, 1.67956196966e-111
};
const double GauLagAbscWei_80[80][2] =
{
	1.79604233007e-002, 4.52726414640e-002,
	9.46399129944e-002, 9.76226911294e-002,
	2.32622868126e-001, 1.33658527980e-001,
	4.31992547802e-001, 1.49376458271e-001,
	6.92828861352e-001, 1.45847069787e-001,
	1.01523255619e+000, 1.27980467667e-001,
	1.39932768784e+000, 1.02403648735e-001,
	1.84526230384e+000, 7.53440573366e-002,
	2.35320887161e+000, 5.12408358211e-002,
	2.92336468656e+000, 3.23231384790e-002,
	3.55595231405e+000, 1.89566601110e-002,
	4.25122008231e+000, 1.03531389322e-002,
	5.00944263362e+000, 5.27160474971e-003,
	5.83092153861e+000, 2.50450073982e-003,
	6.71598597785e+000, 1.11081404793e-003,
	7.66499349489e+000, 4.60099040631e-004,
	8.67833082517e+000, 1.78004273197e-004,
	9.75641480574e+000, 6.43283051818e-005,
	1.08996933713e+001, 2.17141523867e-005,
	1.21086466424e+001, 6.84524220683e-006,
	1.33837881128e+001, 2.01483877687e-006,
	1.47256659435e+001, 5.53560961083e-007,
	1.61348643717e+001, 1.41906623502e-007,
	1.76120052438e+001, 3.39283198861e-008,
	1.91577496842e+001, 7.56185219424e-009,
	2.07727999098e+001, 1.57021037972e-009,
	2.24579012045e+001, 3.03587191513e-010,
	2.42138440690e+001, 5.46149602657e-011,
	2.60414665602e+001, 9.13531174031e-012,
	2.79416568419e+001, 1.41962504129e-012,
	2.99153559649e+001, 2.04781520509e-013,
	3.19635609022e+001, 2.73952672350e-014,
	3.40873278647e+001, 3.39547341644e-015,
	3.62877759288e+001, 3.89500302264e-016,
	3.85660910093e+001, 4.13056523356e-017,
	4.09235302180e+001, 4.04468050247e-018,
	4.33614266517e+001, 3.65238267072e-019,
	4.58811946613e+001, 3.03733902143e-020,
	4.84843356608e+001, 2.32275748067e-021,
	5.11724445446e+001, 1.63092931238e-022,
	5.39472167896e+001, 1.04971073645e-023,
	5.68104563346e+001, 6.18218696667e-025,
	5.97640843421e+001, 3.32533903049e-026,
	6.28101489639e+001, 1.63034213274e-027,
	6.59508362575e+001, 7.27006243716e-029,
	6.91884824202e+001, 2.94182105955e-030,
	7.25255875443e+001, 1.07756632950e-031,
	7.59648311279e+001, 3.56348144549e-033,
	7.95090896291e+001, 1.06090248042e-034,
	8.31614564011e+001, 2.83478933310e-036,
	8.69252644196e+001, 6.77611531375e-038,
	9.08041123009e+001, 1.44381336390e-039,
	9.48018942159e+001, 2.73174196197e-041,
	9.89228344469e+001, 4.57038085062e-043,
	1.03171527508e+002, 6.73093590321e-045,
	1.07552984978e+002, 8.68271484539e-047,
	1.12072690484e+002, 9.75744676650e-049,
	1.16736664674e+002, 9.49576613650e-051,
	1.21551542491e+002, 7.95033724136e-053,
	1.26524665797e+002, 5.68522522122e-055,
	1.31664195252e+002, 3.44436891915e-057,
	1.36979246687e+002, 1.75208383006e-059,
	1.42480058912e+002, 7.40772796198e-062,
	1.48178202455e+002, 2.57353982566e-064,
	1.54086842282e+002, 7.25170568122e-067,
	1.60221072870e+002, 1.63280520163e-069,
	1.66598351934e+002, 2.88751228947e-072,
	1.73239071334e+002, 3.93064971867e-075,
	1.80167323049e+002, 4.02189636954e-078,
	1.87411949677e+002, 3.00656566815e-081,
	1.95008022442e+002, 1.58626293028e-084,
	2.02998984195e+002, 5.65939844204e-088,
	2.11439870495e+002, 1.29345550587e-091,
	2.20402368152e+002, 1.76499777125e-095,
	2.29983206076e+002, 1.30786218055e-099,
	2.40319087056e+002, 4.60386419524e-104,
	2.51615879330e+002, 6.29803564690e-109,
	2.64213823883e+002, 2.40569265303e-114,
	2.78766733046e+002, 1.36484447534e-120,
	2.96966511996e+002, 2.29050625372e-128
};

const double GauLagAbscWei_90[90][2] =
{
	1.59758055709e-002, 4.03498807331e-002,
	8.41808548628e-002, 8.77451659084e-002,
	2.06908553817e-001, 1.21974330071e-001,
	3.84223173487e-001, 1.39346097372e-001,
	6.16181606134e-001, 1.40024077898e-001,
	9.02854826919e-001, 1.27322570032e-001,
	1.24433002037e+000, 1.06295302022e-001,
	1.64071110051e+000, 8.21644352266e-002,
	2.09211898509e+000, 5.91165193782e-002,
	2.59869183326e+000, 3.97293105604e-002,
	3.16058529360e+000, 2.50000077597e-002,
	3.77797277654e+000, 1.47550088210e-002,
	4.45104575662e+000, 8.17793356861e-003,
	5.18001410742e+000, 4.26028822464e-003,
	5.96510647126e+000, 2.08738917816e-003,
	6.80657066574e+000, 9.62348033990e-004,
	7.70467412881e+000, 4.17595728539e-004,
	8.65970440464e+000, 1.70590296837e-004,
	9.67196967244e+000, 6.56090603287e-005,
	1.07417993207e+001, 2.37566746433e-005,
	1.18695445697e+001, 8.09823218120e-006,
	1.30555791449e+001, 2.59848935421e-006,
	1.43003000048e+001, 7.84687976359e-007,
	1.56041281274e+001, 2.22954108868e-007,
	1.69675093578e+001, 5.95871947503e-008,
	1.83909153233e+001, 1.49749902655e-008,
	1.98748444186e+001, 3.53748762576e-009,
	2.14198228694e+001, 7.85161007863e-010,
	2.30264058770e+001, 1.63666932398e-010,
	2.46951788533e+001, 3.20248520083e-011,
	2.64267587519e+001, 5.87902601582e-012,
	2.82217955043e+001, 1.01196665412e-012,
	3.00809735688e+001, 1.63230857516e-013,
	3.20050136037e+001, 2.46563068463e-014,
	3.39946742752e+001, 3.48529282722e-015,
	3.60507542118e+001, 4.60693950269e-016,
	3.81740941196e+001, 5.68989542521e-017,
	4.03655790740e+001, 6.56070320512e-018,
	4.26261410050e+001, 7.05610384887e-019,
	4.49567613948e+001, 7.07195453764e-020,
	4.73584742105e+001, 6.59844386663e-021,
	4.98323690962e+001, 5.72550416113e-022,
	5.23795948515e+001, 4.61500506122e-023,
	5.50013632292e+001, 3.45147666524e-024,
	5.76989530866e+001, 2.39205055896e-025,
	6.04737149323e+001, 1.53424649204e-026,
	6.33270759131e+001, 9.09436337318e-028,
	6.62605452961e+001, 4.97460773256e-029,
	6.92757205054e+001, 2.50710880638e-030,
	7.23742937839e+001, 1.16223077366e-031,
	7.55580595611e+001, 4.94707994128e-033,
	7.88289226211e+001, 1.92986700300e-034,
	8.21889071787e+001, 6.88589475974e-036,
	8.56401669922e+001, 2.24245837375e-037,
	8.91849966611e+001, 6.65020209095e-039,
	9.28258442840e+001, 1.79159866193e-040,
	9.65653256854e+001, 4.37339291675e-042,
	1.00406240455e+002, 9.64639803226e-044,
	1.04351590097e+002, 1.91686092186e-045,
	1.08404598633e+002, 3.42064943907e-047,
	1.12568736101e+002, 5.46294400993e-049,
	1.16847745436e+002, 7.77920420471e-051,
	1.21245673391e+002, 9.83768571856e-053,
	1.25766906250e+002, 1.10005129603e-054,
	1.30416211286e+002, 1.08254011244e-056,
	1.35198785168e+002, 9.32717641093e-059,
	1.40120310789e+002, 6.99659008183e-061,
	1.45187024414e+002, 4.54119017513e-063,
	1.50405795575e+002, 2.53305586204e-065,
	1.55784222807e+002, 1.20515599293e-067,
	1.61330749339e+002, 4.84991404087e-070,
	1.67054804094e+002, 1.63554632890e-072,
	1.72966975249e+002, 4.57380953721e-075,
	1.79079226124e+002, 1.04818608766e-077,
	1.85405166973e+002, 1.94221179260e-080,
	1.91960401660e+002, 2.86517707380e-083,
	1.98762976493e+002, 3.30564525726e-086,
	2.05833971111e+002, 2.92123488091e-089,
	2.13198291420e+002, 1.92931038374e-092,
	2.20885757266e+002, 9.24664735860e-096,
	2.28932633064e+002, 3.10301902839e-099,
	2.37383847545e+002, 6.97559343312e-103,
	2.46296330929e+002, 9.93218494931e-107,
	2.55744256976e+002, 8.32756014513e-111,
	2.65827740316e+002, 3.72683196638e-115,
	2.76688317536e+002, 7.75040282598e-120,
	2.88539220791e+002, 6.08198383560e-125,
	3.01733021677e+002, 1.27810400294e-130,
	3.16947584544e+002, 3.73485847644e-137,
	3.35938165189e+002, 2.83656697162e-145
};

const double GauLagAbscWei_100[100][2] =
{
	1.43861469954e-002, 3.63926058833e-002,
	7.58036120234e-002, 7.96767462128e-002,
	1.86314102057e-001, 1.12115103342e-001,
	3.45969180991e-001, 1.30356612975e-001,
	5.54810937581e-001, 1.34043339728e-001,
	8.12891284116e-001, 1.25407090781e-001,
	1.12027383501e+000, 1.08314112097e-001,
	1.47703432992e+000, 8.70966384700e-002,
	1.88326082634e+000, 6.55510093123e-002,
	2.33905384965e+000, 4.63401335826e-002,
	2.84452654276e+000, 3.08463086277e-002,
	3.39980482745e+000, 1.93678281140e-002,
	4.00502758176e+000, 1.14854423602e-002,
	4.66034683557e+000, 6.43895100161e-003,
	5.36592798559e+000, 3.41497998969e-003,
	6.12195003080e+000, 1.71431974018e-003,
	6.92860582938e+000, 8.14871591588e-004,
	7.78610237786e+000, 3.66854836599e-004,
	8.69466111392e+000, 1.56452074178e-004,
	9.65451824356e+000, 6.32108705289e-005,
	1.06659250941e+001, 2.41957522652e-005,
	1.17291484945e+001, 8.77430976376e-006,
	1.28444711836e+001, 3.01426748600e-006,
	1.40121922497e+001, 9.80833589935e-007,
	1.52326276005e+001, 3.02263874353e-007,
	1.65061104681e+001, 8.82005839530e-008,
	1.78329919493e+001, 2.43642585620e-008,
	1.92136415841e+001, 6.36971137390e-009,
	2.06484479747e+001, 1.57560032046e-009,
	2.21378194477e+001, 3.68632920135e-010,
	2.36821847630e+001, 8.15479892422e-011,
	2.52819938718e+001, 1.70506255683e-011,
	2.69377187276e+001, 3.36821417087e-012,
	2.86498541539e+001, 6.28352495537e-013,
	3.04189187738e+001, 1.10649801598e-013,
	3.22454560045e+001, 1.83835017545e-014,
	3.41300351234e+001, 2.88011505723e-015,
	3.60732524104e+001, 4.25261289734e-016,
	3.80757323731e+001, 5.91443246725e-017,
	4.01381290621e+001, 7.74308910250e-018,
	4.22611274830e+001, 9.53624944908e-019,
	4.44454451143e+001, 1.10409451699e-019,
	4.66918335407e+001, 1.20084697043e-020,
	4.90010802108e+001, 1.22600700749e-021,
	5.13740103327e+001, 1.17402171465e-022,
	5.38114889184e+001, 1.05359406461e-023,
	5.63144229920e+001, 8.85323176847e-025,
	5.88837639783e+001, 6.95919877548e-026,
	6.15205102884e+001, 5.11236981547e-027,
	6.42257101231e+001, 3.50627214882e-028,
	6.70004645164e+001, 2.24264627269e-029,
	6.98459306446e+001, 1.33620942345e-030,
	7.27633254290e+001, 7.40742895758e-032,
	7.57539294659e+001, 3.81586013714e-033,
	7.88190913194e+001, 1.82420019768e-034,
	8.19602322191e+001, 8.08163233606e-036,
	8.51788512112e+001, 3.31306380186e-037,
	8.84765308174e+001, 1.25483299769e-038,
	9.18549432630e+001, 4.38379098016e-040,
	9.53158573488e+001, 1.41013922922e-041,
	9.88611460476e+001, 4.16886399967e-043,
	1.02492794924e+002, 1.13048190448e-044,
	1.06212911488e+002, 2.80603749679e-046,
	1.10023735616e+002, 6.36127057098e-048,
	1.13927651189e+002, 1.31398119598e-049,
	1.17927199133e+002, 2.46681069217e-051,
	1.22025092070e+002, 4.19774702287e-053,
	1.26224230845e+002, 6.45626910491e-055,
	1.30527723207e+002, 8.94733724862e-057,
	1.34938905040e+002, 1.11356697470e-058,
	1.39461364554e+002, 1.24023504226e-060,
	1.44098969977e+002, 1.23137657261e-062,
	1.48855901398e+002, 1.08536744891e-064,
	1.53736687548e+002, 8.45495649096e-067,
	1.58746248512e+002, 5.79263075661e-069,
	1.63889945583e+002, 3.47185477635e-071,
	1.69173639810e+002, 1.80985953356e-073,
	1.74603761182e+002, 8.15375260841e-076,
	1.80187390940e+002, 3.15247254879e-078,
	1.85932360240e+002, 1.03790058992e-080,
	1.91847369372e+002, 2.88487552331e-083,
	1.97942133102e+002, 6.70480122597e-086,
	2.04227559567e+002, 1.28896374644e-088,
	2.10715972862e+002, 2.02484834515e-091,
	2.17421393272e+002, 2.56339221997e-094,
	2.24359894789e+002, 2.57396150752e-097,
	2.31550068025e+002, 2.01265478748e-100,
	2.39013629751e+002, 1.19948441938e-103,
	2.46776240967e+002, 5.31213273154e-107,
	2.54868629257e+002, 1.69596925945e-110,
	2.63328168469e+002, 3.76209729863e-114,
	2.72201170024e+002, 5.53964175445e-118,
	2.81546328284e+002, 5.11064047709e-122,
	2.91440133616e+002, 2.73996546940e-126,
	3.01985855252e+002, 7.71361149264e-131,
	3.13329534004e+002, 9.88249460096e-136,
	3.25691263437e+002, 4.64686300729e-141,
	3.39435101923e+002, 5.62603729502e-147,
	3.55261311889e+002, 8.90503140589e-154,
	3.74984112834e+002, 3.24656516344e-162
};

const double GauLagAbscWei_110[110][2] =
{
	1.30842155961e-002, 3.31421652712e-002,
	6.89428568623e-002, 7.29635297679e-002,
	1.69448693043e-001, 1.03697806473e-001,
	3.14644369859e-001, 1.22320220880e-001,
	5.04562011806e-001, 1.28174907792e-001,
	7.39240759193e-001, 1.22746980074e-001,
	1.01872845678e+000, 1.09005872506e-001,
	1.34308201378e+000, 9.05306609576e-002,
	1.71236754920e+000, 7.06912930109e-002,
	2.12666049345e+000, 5.20846454760e-002,
	2.58604568417e+000, 3.63000644169e-002,
	3.09061746737e+000, 2.39737739369e-002,
	3.64047980738e+000, 1.50234303580e-002,
	4.23574640751e+000, 8.94197750295e-003,
	4.87654084217e+000, 5.05886317786e-003,
	5.56299670104e+000, 2.72189760769e-003,
	6.29525774601e+000, 1.39339551638e-003,
	7.07347808114e+000, 6.78887318000e-004,
	7.89782233647e+000, 3.14876665151e-004,
	8.76846586590e+000, 1.39049814310e-004,
	9.68559496011e+000, 5.84694687845e-005,
	1.06494070749e+001, 2.34118763321e-005,
	1.16601110756e+001, 8.92672324501e-006,
	1.27179274988e+001, 3.24100989903e-006,
	1.38230888316e+001, 1.12039144341e-006,
	1.49758398096e+001, 3.68735976160e-007,
	1.61764377348e+001, 1.15520826994e-007,
	1.74251528137e+001, 3.44457243199e-008,
	1.87222685181e+001, 9.77374411520e-009,
	2.00680819678e+001, 2.63844021617e-009,
	2.14629043394e+001, 6.77476650769e-010,
	2.29070612993e+001, 1.65421787840e-010,
	2.44008934651e+001, 3.83993193791e-011,
	2.59447568966e+001, 8.47146778417e-012,
	2.75390236164e+001, 1.77566415803e-012,
	2.91840821651e+001, 3.53495241268e-013,
	3.08803381908e+001, 6.68145818063e-014,
	3.26282150768e+001, 1.19855776619e-014,
	3.44281546089e+001, 2.03972878136e-015,
	3.62806176865e+001, 3.29175702296e-016,
	3.81860850792e+001, 5.03537034034e-017,
	4.01450582333e+001, 7.29759548803e-018,
	4.21580601319e+001, 1.00151865594e-018,
	4.42256362107e+001, 1.30090262659e-019,
	4.63483553374e+001, 1.59845980326e-020,
	4.85268108565e+001, 1.85687740375e-021,
	5.07616217055e+001, 2.03812593625e-022,
	5.30534336098e+001, 2.11239236889e-023,
	5.54029203610e+001, 2.06600228464e-024,
	5.78107851863e+001, 1.90547502421e-025,
	6.02777622170e+001, 1.65608181200e-026,
	6.28046180648e+001, 1.35531962627e-027,
	6.53921535149e+001, 1.04362211381e-028,
	6.80412053472e+001, 7.55493452296e-030,
	7.07526482969e+001, 5.13726029703e-031,
	7.35273971680e+001, 3.27835366209e-032,
	7.63664091143e+001, 1.96152906655e-033,
	7.92706861040e+001, 1.09930988757e-034,
	8.22412775863e+001, 5.76478258758e-036,
	8.52792833811e+001, 2.82560944092e-037,
	8.83858568142e+001, 1.29304429597e-038,
	9.15622081245e+001, 5.51782137160e-040,
	9.48096081721e+001, 2.19295323310e-041,
	9.81293924818e+001, 8.10634431287e-043,
	1.01522965658e+002, 2.78324301422e-044,
	1.04991806216e+002, 8.86282191304e-046,
	1.08537471875e+002, 2.61347177557e-047,
	1.12161605378e+002, 7.12494903358e-049,
	1.15865940889e+002, 1.79274101479e-050,
	1.19652311053e+002, 4.15562427492e-052,
	1.23522654803e+002, 8.85733448866e-054,
	1.27479026006e+002, 1.73234072172e-055,
	1.31523603074e+002, 3.10233518820e-057,
	1.35658699663e+002, 5.07542585784e-059,
	1.39886776629e+002, 7.56700987544e-061,
	1.44210455419e+002, 1.02545009171e-062,
	1.48632533122e+002, 1.25961482272e-064,
	1.53155999433e+002, 1.39831662807e-066,
	1.57784055853e+002, 1.39842119729e-068,
	1.62520137482e+002, 1.25560977088e-070,
	1.67367937869e+002, 1.00847167591e-072,
	1.72331437459e+002, 7.21688144282e-075,
	1.77414936301e+002, 4.58204285854e-077,
	1.82623091829e+002, 2.56912603669e-079,
	1.87960962741e+002, 1.26575195806e-081,
	1.93434060225e+002, 5.44972090519e-084,
	1.99048408110e+002, 2.03829644148e-086,
	2.04810613961e+002, 6.57933170523e-089,
	2.10727953668e+002, 1.81963442943e-091,
	2.16808472848e+002, 4.27769857776e-094,
	2.23061109391e+002, 8.47251335691e-097,
	2.29495842864e+002, 1.39989474843e-099,
	2.36123878433e+002, 1.90826359909e-102,
	2.42957875732e+002, 2.11931677270e-105,
	2.50012237032e+002, 1.89049319106e-108,
	2.57303474935e+002, 1.33253490394e-111,
	2.64850688516e+002, 7.28283720156e-115,
	2.72676190376e+002, 3.01897450124e-118,
	2.80806348318e+002, 9.24779627627e-122,
	2.89272740263e+002, 2.02904927863e-125,
	2.98113779982e+002, 3.07013906121e-129,
	3.07377075568e+002, 3.05665832972e-133,
	3.17122976352e+002, 1.88686721220e-137,
	3.27430146415e+002, 6.68389532171e-142,
	3.38404815305e+002, 1.22402579126e-146,
	3.50197250611e+002, 1.00008836959e-151,
	3.63033983887e+002, 2.92119398282e-157,
	3.77289849032e+002, 2.11706202000e-163,
	3.93686112712e+002, 1.89260664673e-170,
	4.14092263626e+002, 3.47904700589e-179
};

const double GauLagAbscWei_120[120][2] =
{
	1.19983762543e-002, 3.04247176186e-002,
	6.32209692953e-002, 6.72913283192e-002,
	1.55383485473e-001, 9.64352506628e-002,
	2.88522063460e-001, 1.15129252168e-001,
	4.62661866639e-001, 1.22552687271e-001,
	6.77833155992e-001, 1.19668016561e-001,
	9.34072827013e-001, 1.08763809885e-001,
	1.23142472545e+000, 9.27946383750e-002,
	1.56993976333e+000, 7.47167210747e-002,
	1.94967599191e+000, 5.69804406536e-002,
	2.37069866639e+000, 4.12606143417e-002,
	2.83308031237e+000, 2.84206711032e-002,
	3.33690079718e+000, 1.86468081948e-002,
	3.88224740774e+000, 1.16650258488e-002,
	4.46921493546e+000, 6.96327443826e-003,
	5.09790576866e+000, 3.96867930190e-003,
	5.76842999291e+000, 2.16063811099e-003,
	6.48090549947e+000, 1.12402024527e-003,
	7.23545810220e+000, 5.58904907562e-004,
	8.03222166319e+000, 2.65680083214e-004,
	8.87133822756e+000, 1.20753056403e-004,
	9.75295816755e+000, 5.24801680556e-005,
	1.06772403365e+001, 2.18108359466e-005,
	1.16443522328e+001, 8.66834132317e-006,
	1.26544701750e+001, 3.29442235584e-006,
	1.37077794871e+001, 1.19724484284e-006,
	1.48044746963e+001, 4.16022653945e-007,
	1.59447597422e+001, 1.38210533295e-007,
	1.71288481990e+001, 4.38940881341e-008,
	1.83569635108e+001, 1.33245800550e-008,
	1.96293392412e+001, 3.86560359490e-009,
	2.09462193370e+001, 1.07157663133e-009,
	2.23078584077e+001, 2.83785100154e-010,
	2.37145220214e+001, 7.17839538101e-011,
	2.51664870174e+001, 1.73396543152e-011,
	2.66640418374e+001, 3.99876220823e-012,
	2.82074868756e+001, 8.80182347644e-013,
	2.97971348489e+001, 1.84869207066e-013,
	3.14333111889e+001, 3.70405422782e-014,
	3.31163544568e+001, 7.07750112572e-015,
	3.48466167819e+001, 1.28924187679e-015,
	3.66244643264e+001, 2.23818294918e-016,
	3.84502777774e+001, 3.70178450060e-017,
	4.03244528677e+001, 5.83070856439e-018,
	4.22474009279e+001, 8.74296909334e-019,
	4.42195494722e+001, 1.24752426462e-019,
	4.62413428186e+001, 1.69320146558e-020,
	4.83132427474e+001, 2.18497677493e-021,
	5.04357292011e+001, 2.67956409240e-022,
	5.26093010263e+001, 3.12142218738e-023,
	5.48344767633e+001, 3.45219122109e-024,
	5.71117954857e+001, 3.62297023797e-025,
	5.94418176938e+001, 3.60600437631e-026,
	6.18251262658e+001, 3.40199150022e-027,
	6.42623274721e+001, 3.04038914621e-028,
	6.67540520571e+001, 2.57244850094e-029,
	6.93009563933e+001, 2.05924014356e-030,
	7.19037237156e+001, 1.55854533288e-031,
	7.45630654404e+001, 1.11450220774e-032,
	7.72797225773e+001, 7.52446056235e-034,
	8.00544672432e+001, 4.79261984814e-035,
	8.28881042840e+001, 2.87759488857e-036,
	8.57814730180e+001, 1.62736954526e-037,
	8.87354491082e+001, 8.66098912783e-039,
	9.17509465782e+001, 4.33392867445e-040,
	9.48289199836e+001, 2.03713352294e-041,
	9.79703667549e+001, 8.98571306275e-043,
	1.01176329728e+002, 3.71563467312e-044,
	1.04447899881e+002, 1.43877223944e-045,
	1.07786219300e+002, 5.21121094169e-047,
	1.11192484394e+002, 1.76342998742e-048,
	1.14667949393e+002, 5.56815205104e-050,
	1.18213930145e+002, 1.63844123318e-051,
	1.21831808266e+002, 4.48665528590e-053,
	1.25523035667e+002, 1.14172441513e-054,
	1.29289139500e+002, 2.69580675329e-056,
	1.33131727591e+002, 5.89674495608e-058,
	1.37052494396e+002, 1.19289391115e-059,
	1.41053227565e+002, 2.22785374114e-061,
	1.45135815170e+002, 3.83400781992e-063,
	1.49302253710e+002, 6.06792249206e-065,
	1.53554656964e+002, 8.81325551047e-067,
	1.57895265845e+002, 1.17212979970e-068,
	1.62326459358e+002, 1.42407268906e-070,
	1.66850766855e+002, 1.57657605393e-072,
	1.71470881753e+002, 1.58621642276e-074,
	1.76189676957e+002, 1.44622450617e-076,
	1.81010222244e+002, 1.19127179958e-078,
	1.85935803938e+002, 8.83630358921e-081,
	1.90969947245e+002, 5.88159078053e-083,
	1.96116441719e+002, 3.49984860364e-085,
	2.01379370418e+002, 1.85427185619e-087,
	2.06763143427e+002, 8.70895021239e-090,
	2.12272536590e+002, 3.60883904520e-092,
	2.17912736487e+002, 1.31263126425e-094,
	2.23689392951e+002, 4.16731507206e-097,
	2.29608680739e+002, 1.14774987808e-099,
	2.35677372427e+002, 2.72393851427e-102,
	2.41902925156e+002, 5.52960211121e-105,
	2.48293584619e+002, 9.52325487701e-108,
	2.54858510746e+002, 1.37888288005e-110,
	2.61607930947e+002, 1.66156257539e-113,
	2.68553328794e+002, 1.64744464962e-116,
	2.75707678808e+002, 1.32686646948e-119,
	2.83085742141e+002, 8.55493529604e-123,
	2.90704443868e+002, 4.34212400096e-126,
	2.98583361641e+002, 1.70164756662e-129,
	3.06745369267e+002, 5.03376467214e-133,
	3.15217500686e+002, 1.09437279934e-136,
	3.24032135617e+002, 1.69353193746e-140,
	3.33228668780e+002, 1.79426234779e-144,
	3.42855931753e+002, 1.24028901743e-148,
	3.52975835720e+002, 5.26267976582e-153,
	3.63669096393e+002, 1.26600031832e-157,
	3.75044737412e+002, 1.55119641842e-162,
	3.87257015558e+002, 8.32117793289e-168,
	4.00538537634e+002, 1.55644029687e-173,
	4.15274303677e+002, 6.97371948578e-180,
	4.32205390729e+002, 3.64809173123e-187,
	4.53253394274e+002, 3.52524257384e-196
};

const double GauLagAbscWei_130[130][2] =
{
	1.10789515860e-002, 2.81191063188e-002,
	5.83760990687e-002, 6.24358923094e-002,
	1.43474492872e-001, 9.01095418277e-002,
	2.66405368036e-001, 1.08678091200e-001,
	4.27188871784e-001, 1.17236887900e-001,
	6.25848899430e-001, 1.16378079829e-001,
	8.62414506481e-001, 1.07869602020e-001,
	1.13692019145e+000, 9.41527650905e-002,
	1.44940599251e+000, 7.78040483659e-002,
	1.79991754263e+000, 6.10897607434e-002,
	2.18850611534e+000, 4.56905749968e-002,
	2.61522867016e+000, 3.26114710758e-002,
	3.08014790073e+000, 2.22428244859e-002,
	3.58333228700e+000, 1.45121875930e-002,
	4.12485615182e+000, 9.06449609885e-003,
	4.70479972253e+000, 5.42362870388e-003,
	5.32324919754e+000, 3.11014696485e-003,
	5.98029681824e+000, 1.70993729857e-003,
	6.67604094632e+000, 9.01602814222e-004,
	7.41058614672e+000, 4.56020534096e-004,
	8.18404327644e+000, 2.21290039450e-004,
	8.99652957927e+000, 1.03039058395e-004,
	9.84816878678e+000, 4.60406758865e-005,
	1.07390912257e+001, 1.97425823676e-005,
	1.16694339319e+001, 8.12453763885e-006,
	1.26393407716e+001, 3.20866630605e-006,
	1.36489625690e+001, 1.21610320938e-006,
	1.46984572425e+001, 4.42299093539e-007,
	1.57879899473e+001, 1.54359336872e-007,
	1.69177332275e+001, 5.16874246580e-008,
	1.80878671759e+001, 1.66046152211e-008,
	1.92985796023e+001, 5.11699260622e-009,
	2.05500662118e+001, 1.51246937656e-009,
	2.18425307925e+001, 4.28728074449e-010,
	2.31761854132e+001, 1.16528629423e-010,
	2.45512506315e+001, 3.03644134440e-011,
	2.59679557138e+001, 7.58401698167e-012,
	2.74265388662e+001, 1.81531071913e-012,
	2.89272474784e+001, 4.16322274663e-013,
	3.04703383801e+001, 9.14617860814e-014,
	3.20560781113e+001, 1.92433224601e-014,
	3.36847432074e+001, 3.87654124343e-015,
	3.53566204984e+001, 7.47516794476e-016,
	3.70720074259e+001, 1.37940712590e-016,
	3.88312123757e+001, 2.43520875041e-017,
	4.06345550290e+001, 4.11172254013e-018,
	4.24823667330e+001, 6.63775528821e-019,
	4.43749908911e+001, 1.02420914948e-019,
	4.63127833756e+001, 1.51001147355e-020,
	4.82961129619e+001, 2.12639600117e-021,
	5.03253617885e+001, 2.85905315097e-022,
	5.24009258420e+001, 3.66901896882e-023,
	5.45232154697e+001, 4.49217005819e-024,
	5.66926559221e+001, 5.24521111633e-025,
	5.89096879261e+001, 5.83828548338e-026,
	6.11747682928e+001, 6.19200077527e-027,
	6.34883705597e+001, 6.25460981571e-028,
	6.58509856729e+001, 6.01430453721e-029,
	6.82631227092e+001, 5.50263766690e-030,
	7.07253096430e+001, 4.78776314110e-031,
	7.32380941606e+001, 3.95947699359e-032,
	7.58020445249e+001, 3.11060240966e-033,
	7.84177504957e+001, 2.32007112524e-034,
	8.10858243086e+001, 1.64190079823e-035,
	8.38069017179e+001, 1.10181763495e-036,
	8.65816431076e+001, 7.00659927365e-038,
	8.94107346782e+001, 4.21935293162e-039,
	9.22948897123e+001, 2.40447272064e-040,
	9.52348499290e+001, 1.29572032759e-041,
	9.82313869320e+001, 6.59764675957e-043,
	1.01285303761e+002, 3.17181951387e-044,
	1.04397436554e+002, 1.43850153796e-045,
	1.07568656337e+002, 6.14922395684e-047,
	1.10799870935e+002, 2.47541527117e-048,
	1.14092027042e+002, 9.37532583807e-050,
	1.17446112445e+002, 3.33741457673e-051,
	1.20863158418e+002, 1.11551520336e-052,
	1.24344242313e+002, 3.49718379111e-054,
	1.27890490365e+002, 1.02719747032e-055,
	1.31503080720e+002, 2.82341259333e-057,
	1.35183246731e+002, 7.25350923291e-059,
	1.38932280531e+002, 1.73947603220e-060,
	1.42751536920e+002, 3.88867022485e-062,
	1.46642437609e+002, 8.09250810970e-064,
	1.50606475848e+002, 1.56538285539e-065,
	1.54645221490e+002, 2.81019412546e-067,
	1.58760326542e+002, 4.67431306618e-069,
	1.62953531259e+002, 7.19141362630e-071,
	1.67226670853e+002, 1.02148968604e-072,
	1.71581682893e+002, 1.33702948584e-074,
	1.76020615477e+002, 1.60935395024e-076,
	1.80545636304e+002, 1.77758514310e-078,
	1.85159042734e+002, 1.79757164623e-080,
	1.89863273010e+002, 1.66022467296e-082,
	1.94660918776e+002, 1.39686387247e-084,
	1.99554739122e+002, 1.06771993305e-086,
	2.04547676349e+002, 7.39276864785e-089,
	2.09642873754e+002, 4.62218326758e-091,
	2.14843695753e+002, 2.60091366539e-093,
	2.20153750730e+002, 1.31246196903e-095,
	2.25576917090e+002, 5.91638534052e-098,
	2.31117373084e+002, 2.37264537511e-100,
	2.36779631108e+002, 8.42693501016e-103,
	2.42568577334e+002, 2.63790827692e-105,
	2.48489517730e+002, 7.23960732493e-108,
	2.54548231803e+002, 1.73198368999e-110,
	2.60751035714e+002, 3.58941178143e-113,
	2.67104856883e+002, 6.39981916413e-116,
	2.73617322773e+002, 9.74294328759e-119,
	2.80296867340e+002, 1.25590568076e-121,
	2.87152859697e+002, 1.35810261627e-124,
	2.94195761004e+002, 1.21930376998e-127,
	3.01437317652e+002, 8.98334325217e-131,
	3.08890801690e+002, 5.36041855984e-134,
	3.16571313613e+002, 2.55209690273e-137,
	3.24496168789e+002, 9.52985595889e-141,
	3.32685397959e+002, 2.73624481477e-144,
	3.41162406512e+002, 5.90263151590e-148,
	3.49954859607e+002, 9.30844287666e-152,
	3.59095896985e+002, 1.03854427098e-155,
	3.68625843418e+002, 7.87759639507e-160,
	3.78594690689e+002, 3.86685980548e-164,
	3.89065831205e+002, 1.15392477560e-168,
	4.00121926449e+002, 1.92974679247e-173,
	4.11874649922e+002, 1.62045745518e-178,
	4.24482041314e+002, 5.85090413532e-184,
	4.38182467668e+002, 7.19276072537e-190,
	4.53370565987e+002, 2.04841862364e-196,
	4.70806187319e+002, 6.46415179768e-204,
	4.92460290388e+002, 3.40373832379e-213
};

const double GauLagAbscWei_140[140][2] =
{
	1.02904075685e-002, 2.61383075593e-002,
	5.42209572893e-002, 5.82329465686e-002,
	1.33261153530e-001, 8.45531484558e-002,
	2.47438434134e-001, 1.02871073928e-001,
	3.96769235595e-001, 1.12247619169e-001,
	5.81272769656e-001, 1.13010025015e-001,
	8.00972330455e-001, 1.06525019357e-001,
	1.05589555170e+000, 9.48132842940e-002,
	1.34607448985e+000, 8.01128406149e-002,
	1.67154566761e+000, 6.44935649802e-002,
	2.03235010762e+000, 4.95919563810e-002,
	2.42853336470e+000, 3.64909554359e-002,
	2.86014555938e+000, 2.57296580627e-002,
	3.32724141401e+000, 1.74024806195e-002,
	3.82988029179e+000, 1.12997170635e-002,
	4.36812623902e+000, 7.04819504600e-003,
	4.94204803084e+000, 4.22531319533e-003,
	5.55171922036e+000, 2.43546709914e-003,
	6.19721819159e+000, 1.35015654307e-003,
	6.87862821598e+000, 7.20065430607e-004,
	7.59603751296e+000, 3.69513090508e-004,
	8.34953931433e+000, 1.82482967583e-004,
	9.13923193281e+000, 8.67356672038e-005,
	9.96521883481e+000, 3.96817008758e-005,
	1.08276087175e+001, 1.74752030251e-005,
	1.17265155905e+001, 7.40807322418e-006,
	1.26620588621e+001, 3.02302513395e-006,
	1.36343634302e+001, 1.18747846020e-006,
	1.46435597788e+001, 4.48997289040e-007,
	1.56897840785e+001, 1.63408755014e-007,
	1.67731782941e+001, 5.72392373251e-008,
	1.78938902960e+001, 1.92959722188e-008,
	1.90520739785e+001, 6.25973089285e-009,
	2.02478893840e+001, 1.95396805720e-009,
	2.14815028333e+001, 5.86818357932e-010,
	2.27530870625e+001, 1.69535715966e-010,
	2.40628213667e+001, 4.71120727908e-011,
	2.54108917516e+001, 1.25908318588e-011,
	2.67974910913e+001, 3.23564707013e-012,
	2.82228192951e+001, 7.99431664046e-013,
	2.96870834821e+001, 1.89862730096e-013,
	3.11904981643e+001, 4.33367879118e-014,
	3.27332854391e+001, 9.50492194091e-015,
	3.43156751910e+001, 2.00275219616e-015,
	3.59379053034e+001, 4.05322253347e-016,
	3.76002218812e+001, 7.87719728741e-017,
	3.93028794838e+001, 1.46973894509e-017,
	4.10461413705e+001, 2.63208972017e-018,
	4.28302797579e+001, 4.52317678440e-019,
	4.46555760899e+001, 7.45683795303e-020,
	4.65223213220e+001, 1.17900439696e-020,
	4.84308162196e+001, 1.78732016390e-021,
	5.03813716721e+001, 2.59709213322e-022,
	5.23743090225e+001, 3.61607478531e-023,
	5.44099604148e+001, 4.82296887332e-024,
	5.64886691591e+001, 6.15992383343e-025,
	5.86107901164e+001, 7.53132839002e-026,
	6.07766901034e+001, 8.81148842888e-027,
	6.29867483195e+001, 9.86163431978e-028,
	6.52413567966e+001, 1.05537095169e-028,
	6.75409208736e+001, 1.07955983947e-029,
	6.98858596975e+001, 1.05510622836e-030,
	7.22766067515e+001, 9.84849082498e-032,
	7.47136104139e+001, 8.77559839554e-033,
	7.71973345488e+001, 7.46139467904e-034,
	7.97282591297e+001, 6.05055256568e-035,
	8.23068809010e+001, 4.67724316274e-036,
	8.49337140779e+001, 3.44496792336e-037,
	8.76092910876e+001, 2.41631288616e-038,
	9.03341633564e+001, 1.61308778458e-039,
	9.31089021444e+001, 1.02436581729e-040,
	9.59340994318e+001, 6.18430249918e-042,
	9.88103688621e+001, 3.54733170544e-043,
	1.01738346744e+002, 1.93203622936e-044,
	1.04718693119e+002, 9.98499213994e-046,
	1.07752092899e+002, 4.89333502688e-047,
	1.10839257081e+002, 2.27238202300e-048,
	1.13980924039e+002, 9.99216050658e-050,
	1.17177860914e+002, 4.15727837816e-051,
	1.20430865087e+002, 1.63526183682e-052,
	1.23740765773e+002, 6.07626915981e-054,
	1.27108425714e+002, 2.13101582544e-055,
	1.30534743010e+002, 7.04773293032e-057,
	1.34020653072e+002, 2.19594892197e-058,
	1.37567130736e+002, 6.43998584152e-060,
	1.41175192533e+002, 1.77582128225e-061,
	1.44845899136e+002, 4.59947144325e-063,
	1.48580358008e+002, 1.11772077542e-064,
	1.52379726263e+002, 2.54551905797e-066,
	1.56245213758e+002, 5.42644111259e-068,
	1.60178086462e+002, 1.08144229779e-069,
	1.64179670100e+002, 2.01219043916e-071,
	1.68251354125e+002, 3.49070122952e-073,
	1.72394596050e+002, 5.63774096324e-075,
	1.76610926171e+002, 8.46419982161e-077,
	1.80901952742e+002, 1.17939931373e-078,
	1.85269367636e+002, 1.52264863498e-080,
	1.89714952572e+002, 1.81816488509e-082,
	1.94240585964e+002, 2.00424445278e-084,
	1.98848250471e+002, 2.03561699271e-086,
	2.03540041350e+002, 1.90092454890e-088,
	2.08318175710e+002, 1.62854590751e-090,
	2.13185002790e+002, 1.27698941369e-092,
	2.18143015410e+002, 9.14219841821e-095,
	2.23194862767e+002, 5.96000277513e-097,
	2.28343364762e+002, 3.52823522961e-099,
	2.33591528109e+002, 1.89097616640e-101,
	2.38942564496e+002, 9.14630835708e-104,
	2.44399911134e+002, 3.97881231500e-106,
	2.49967254099e+002, 1.55102281523e-108,
	2.55648554937e+002, 5.39672880308e-111,
	2.61448081134e+002, 1.66897333736e-113,
	2.67370441151e+002, 4.56653104559e-116,
	2.73420624910e+002, 1.09999103092e-118,
	2.79604050814e+002, 2.32017403625e-121,
	2.85926620651e+002, 4.26025427728e-124,
	2.92394784089e+002, 6.76632783473e-127,
	2.99015614911e+002, 9.23046418687e-130,
	3.05796901742e+002, 1.07322289754e-132,
	3.12747256846e+002, 1.05448607205e-135,
	3.19876247622e+002, 8.67269884904e-139,
	3.27194556978e+002, 5.90783948329e-142,
	3.34714180807e+002, 3.29380941740e-145,
	3.42448673777e+002, 1.48295670666e-148,
	3.50413458904e+002, 5.30984032200e-152,
	3.58626222660e+002, 1.48576086058e-155,
	3.67107426784e+002, 3.18369918767e-159,
	3.75880982485e+002, 5.10215216637e-163,
	3.84975155723e+002, 5.94662068811e-167,
	3.94423809771e+002, 4.87465357604e-171,
	4.04268154943e+002, 2.69831667875e-175,
	4.14559287804e+002, 9.58986428121e-180,
	4.25362011285e+002, 2.05280313186e-184,
	4.36760839755e+002, 2.43523563426e-189,
	4.48869969937e+002, 1.43089212725e-194,
	4.61851043272e+002, 3.55313898953e-200,
	4.75947910363e+002, 2.93637400134e-206,
	4.91564380468e+002, 5.44475877169e-213,
	5.09478168823e+002, 1.06430026165e-220,
	5.31707190231e+002, 3.15085611574e-230
};

const double GauLagAbscWei_150[150][2] =
{
	9.60665462941e-003, 2.44182015965e-002,
	5.06180404505e-002, 5.45594326732e-002,
	1.24405362070e-001, 7.96355391825e-002,
	2.30993048037e-001, 9.76245334033e-002,
	3.70394727306e-001, 1.07583359646e-001,
	5.42626088246e-001, 1.09648434973e-001,
	7.47706096035e-001, 1.04874933542e-001,
	9.85657229147e-001, 9.49386862352e-002,
	1.25650555270e+000, 8.17809291945e-002,
	1.56028075406e+000, 6.72770696056e-002,
	1.89701616855e+000, 5.29896333337e-002,
	2.26674880303e+000, 4.00337077407e-002,
	2.66951936004e+000, 2.90516961547e-002,
	3.10537226343e+000, 2.02715046426e-002,
	3.57435568603e+000, 1.36120969883e-002,
	4.07652157947e+000, 8.80174017617e-003,
	4.61192570642e+000, 5.48326022983e-003,
	5.18062767518e+000, 3.29240862724e-003,
	5.78269097682e+000, 1.90605635819e-003,
	6.41818302494e+000, 1.06419011442e-003,
	7.08717519799e+000, 5.73133138097e-004,
	7.78974288442e+000, 2.97794701272e-004,
	8.52596553053e+000, 1.49300054359e-004,
	9.29592669123e+000, 7.22316307839e-005,
	1.00997140838e+001, 3.37248973154e-005,
	1.09374196445e+001, 1.51967547567e-005,
	1.18091395888e+001, 6.60907199115e-006,
	1.27149744739e+001, 2.77411261504e-006,
	1.36550292657e+001, 1.12382636180e-006,
	1.46294134086e+001, 4.39396971912e-007,
	1.56382408987e+001, 1.65799422387e-007,
	1.66816303611e+001, 6.03749973444e-008,
	1.77597051308e+001, 2.12155589545e-008,
	1.88725933376e+001, 7.19358715238e-009,
	2.00204279951e+001, 2.35340280323e-009,
	2.12033470940e+001, 7.42794411403e-010,
	2.24214936997e+001, 2.26162440636e-010,
	2.36750160547e+001, 6.64210716640e-011,
	2.49640676856e+001, 1.88137402626e-011,
	2.62888075153e+001, 5.13895700382e-012,
	2.76493999799e+001, 1.35346976413e-012,
	2.90460151520e+001, 3.43665186318e-013,
	3.04788288688e+001, 8.41147501383e-014,
	3.19480228661e+001, 1.98422644556e-014,
	3.34537849192e+001, 4.51047400029e-015,
	3.49963089899e+001, 9.87850081001e-016,
	3.65757953799e+001, 2.08410903341e-016,
	3.81924508916e+001, 4.23476774609e-017,
	3.98464889970e+001, 8.28579744638e-018,
	4.15381300129e+001, 1.56079875044e-018,
	4.32676012860e+001, 2.82993334216e-019,
	4.50351373852e+001, 4.93773152232e-020,
	4.68409803037e+001, 8.28900437982e-021,
	4.86853796705e+001, 1.33843994069e-021,
	5.05685929718e+001, 2.07831457595e-022,
	5.24908857830e+001, 3.10263006049e-023,
	5.44525320117e+001, 4.45186072553e-024,
	5.64538141527e+001, 6.13802369188e-025,
	5.84950235550e+001, 8.12960497503e-026,
	6.05764607023e+001, 1.03404277356e-026,
	6.26984355066e+001, 1.26271613139e-027,
	6.48612676173e+001, 1.47991470638e-028,
	6.70652867453e+001, 1.66414972826e-029,
	6.93108330029e+001, 1.79485433569e-030,
	7.15982572622e+001, 1.85608830556e-031,
	7.39279215310e+001, 1.83970088971e-032,
	7.63001993485e+001, 1.74709437151e-033,
	7.87154762017e+001, 1.58906685194e-034,
	8.11741499641e+001, 1.38374235549e-035,
	8.36766313573e+001, 1.15313588156e-036,
	8.62233444382e+001, 9.19257029415e-038,
	8.88147271120e+001, 7.00708830681e-039,
	9.14512316747e+001, 5.10492053571e-040,
	9.41333253847e+001, 3.55296706379e-041,
	9.68614910674e+001, 2.36122507210e-042,
	9.96362277548e+001, 1.49766165520e-043,
	1.02458051361e+002, 9.06147467722e-045,
	1.05327495397e+002, 5.22713760132e-046,
	1.08245111733e+002, 2.87323988840e-047,
	1.11211471397e+002, 1.50410241148e-048,
	1.14227165430e+002, 7.49421996117e-050,
	1.17292805795e+002, 3.55185970106e-051,
	1.20409026334e+002, 1.60026835122e-052,
	1.23576483796e+002, 6.84943615246e-054,
	1.26795858922e+002, 2.78322767748e-055,
	1.30067857614e+002, 1.07292790532e-056,
	1.33393212164e+002, 3.92107153153e-058,
	1.36772682584e+002, 1.35745018854e-059,
	1.40207058012e+002, 4.44823587988e-061,
	1.43697158226e+002, 1.37861517329e-062,
	1.47243835261e+002, 4.03759005990e-064,
	1.50847975143e+002, 1.11645999880e-065,
	1.54510499749e+002, 2.91211291062e-067,
	1.58232368806e+002, 7.15819089484e-069,
	1.62014582041e+002, 1.65652110100e-070,
	1.65858181498e+002, 3.60528487262e-072,
	1.69764254034e+002, 7.37160422188e-074,
	1.73733934018e+002, 1.41440758985e-075,
	1.77768406244e+002, 2.54369953023e-077,
	1.81868909095e+002, 4.28253624789e-079,
	1.86036737961e+002, 6.74094805281e-081,
	1.90273248968e+002, 9.90695154785e-083,
	1.94579863022e+002, 1.35751504138e-084,
	1.98958070225e+002, 1.73177447723e-086,
	2.03409434692e+002, 2.05354691312e-088,
	2.07935599826e+002, 2.25982501751e-090,
	2.12538294090e+002, 2.30385646583e-092,
	2.17219337354e+002, 2.17200338789e-094,
	2.21980647881e+002, 1.88999916440e-096,
	2.26824250022e+002, 1.51490189574e-098,
	2.31752282738e+002, 1.11610604035e-100,
	2.36767009027e+002, 7.54131679016e-103,
	2.41870826414e+002, 4.66202233505e-105,
	2.47066278622e+002, 2.63019848788e-107,
	2.52356068621e+002, 1.35058699902e-109,
	2.57743073244e+002, 6.29410994838e-112,
	2.63230359606e+002, 2.65399179973e-114,
	2.68821203639e+002, 1.00926226558e-116,
	2.74519111039e+002, 3.44932678974e-119,
	2.80327841081e+002, 1.05552325414e-121,
	2.86251433756e+002, 2.88045261762e-124,
	2.92294240854e+002, 6.97967274064e-127,
	2.98460961703e+002, 1.49473069688e-129,
	3.04756684476e+002, 2.81480991504e-132,
	3.11186934158e+002, 4.63564239183e-135,
	3.17757728576e+002, 6.63666345428e-138,
	3.24475644200e+002, 8.20601769475e-141,
	3.31347893938e+002, 8.70057029968e-144,
	3.38382419733e+002, 7.84823021878e-147,
	3.45588003587e+002, 5.97061726217e-150,
	3.52974401782e+002, 3.79390071621e-153,
	3.60552508574e+002, 1.99195001026e-156,
	3.68334557774e+002, 8.53743620747e-160,
	3.76334373667e+002, 2.94632477920e-163,
	3.84567687072e+002, 8.06058783125e-167,
	3.93052538750e+002, 1.71720882638e-170,
	4.01809802017e+002, 2.79043539600e-174,
	4.10863871226e+002, 3.37618122027e-178,
	4.20243586298e+002, 2.95591532646e-182,
	4.29983501819e+002, 1.80980284756e-186,
	4.40125674278e+002, 7.43352034405e-191,
	4.50722255963e+002, 1.94543810705e-195,
	4.61839397698e+002, 3.03919576134e-200,
	4.73563384414e+002, 2.60310630879e-205,
	4.86010823767e+002, 1.08988848952e-210,
	4.99346798300e+002, 1.89670578244e-216,
	5.13820396821e+002, 1.07478659298e-222,
	5.29844188812e+002, 1.32529845286e-229,
	5.48212947305e+002, 1.64250522411e-237,
	5.70989410774e+002, 2.81041117109e-247
};

const double GauLagAbscWei_160[160][2] =
{
	9.00810538529e-003, 2.29105029570e-002,
	4.74641183865e-002, 5.13213647837e-002,
	1.16653304812e-001, 7.52537134129e-002,
	2.16597660395e-001, 9.28664727160e-002,
	3.47308647987e-001, 1.03231276588e-001,
	5.08799253891e-001, 1.06346515943e-001,
	7.01085127471e-001, 1.03023669301e-001,
	9.24184800485e-001, 9.46552222460e-002,
	1.17811975298e+000, 8.29245254629e-002,
	1.46291444331e+000, 6.95221864636e-002,
	1.77859632842e+000, 5.59204972785e-002,
	2.12519588158e+000, 4.32345418446e-002,
	2.50274661022e+000, 3.21740529735e-002,
	2.91128507460e+000, 2.30705100779e-002,
	3.35085090787e+000, 1.59530811681e-002,
	3.82148683769e+000, 1.06451503970e-002,
	4.32323870940e+000, 6.85812685352e-003,
	4.85615551103e+000, 4.26764282859e-003,
	5.42028939999e+000, 2.56594257836e-003,
	6.01569573166e+000, 1.49108252789e-003,
	6.64243308977e+000, 8.37624145055e-004,
	7.30056331880e+000, 4.54954164575e-004,
	7.99015155823e+000, 2.38956942142e-004,
	8.71126627889e+000, 1.21382097836e-004,
	9.46397932128e+000, 5.96363129364e-005,
	1.02483659362e+001, 2.83410902547e-005,
	1.10645048271e+001, 1.30284253423e-005,
	1.19124781954e+001, 5.79361223674e-006,
	1.27923717875e+001, 2.49226894594e-006,
	1.37042749441e+001, 1.03711822755e-006,
	1.46482806525e+001, 4.17487996292e-007,
	1.56244856011e+001, 1.62566713899e-007,
	1.66329902364e+001, 6.12316778001e-008,
	1.76738988226e+001, 2.23078828387e-008,
	1.87473195046e+001, 7.86058781853e-009,
	1.98533643730e+001, 2.67879361283e-009,
	2.09921495326e+001, 8.82837158818e-010,
	2.21637951740e+001, 2.81348925759e-010,
	2.33684256479e+001, 8.66954249297e-011,
	2.46061695434e+001, 2.58281435774e-011,
	2.58771597690e+001, 7.43863247700e-012,
	2.71815336378e+001, 2.07085532705e-012,
	2.85194329557e+001, 5.57203867469e-013,
	2.98910041146e+001, 1.44888628676e-013,
	3.12963981878e+001, 3.64045445535e-014,
	3.27357710317e+001, 8.83731920169e-015,
	3.42092833900e+001, 2.07237752350e-015,
	3.57171010035e+001, 4.69394059500e-016,
	3.72593947243e+001, 1.02674103963e-016,
	3.88363406349e+001, 2.16855447671e-017,
	4.04481201725e+001, 4.42175341362e-018,
	4.20949202589e+001, 8.70280706160e-019,
	4.37769334354e+001, 1.65305727666e-019,
	4.54943580044e+001, 3.02970510167e-020,
	4.72473981766e+001, 5.35690605181e-021,
	4.90362642248e+001, 9.13573059691e-022,
	5.08611726446e+001, 1.50244818803e-022,
	5.27223463221e+001, 2.38227030047e-023,
	5.46200147091e+001, 3.64102057600e-024,
	5.65544140062e+001, 5.36287767259e-025,
	5.85257873536e+001, 7.61051738366e-026,
	6.05343850316e+001, 1.04032152705e-026,
	6.25804646692e+001, 1.36946300559e-027,
	6.46642914628e+001, 1.73560579171e-028,
	6.67861384047e+001, 2.11716716590e-029,
	6.89462865226e+001, 2.48510105771e-030,
	7.11450251301e+001, 2.80605151236e-031,
	7.33826520888e+001, 3.04708032289e-032,
	7.56594740834e+001, 3.18111149500e-033,
	7.79758069096e+001, 3.19188021228e-034,
	8.03319757762e+001, 3.07715074544e-035,
	8.27283156217e+001, 2.84933113073e-036,
	8.51651714471e+001, 2.53327330472e-037,
	8.76428986643e+001, 2.16179520394e-038,
	9.01618634632e+001, 1.77004406949e-039,
	9.27224431966e+001, 1.39004662629e-040,
	9.53250267853e+001, 1.04660801599e-041,
	9.79700151440e+001, 7.55225278362e-043,
	1.00657821630e+002, 5.22071115497e-044,
	1.03388872515e+002, 3.45589672187e-045,
	1.06163607482e+002, 2.18968261902e-046,
	1.08982480151e+002, 1.32738285569e-047,
	1.11845958633e+002, 7.69493251017e-049,
	1.14754526112e+002, 4.26382514061e-050,
	1.17708681462e+002, 2.25717616207e-051,
	1.20708939902e+002, 1.14098894984e-052,
	1.23755833682e+002, 5.50450580527e-054,
	1.26849912815e+002, 2.53302460792e-055,
	1.29991745851e+002, 1.11121953251e-056,
	1.33181920696e+002, 4.64458051328e-058,
	1.36421045480e+002, 1.84849080970e-059,
	1.39709749481e+002, 7.00069375727e-061,
	1.43048684110e+002, 2.52137274573e-062,
	1.46438523946e+002, 8.63007095232e-064,
	1.49879967854e+002, 2.80525037919e-065,
	1.53373740164e+002, 8.65359195511e-067,
	1.56920591934e+002, 2.53142285191e-068,
	1.60521302294e+002, 7.01681928802e-070,
	1.64176679888e+002, 1.84151060055e-071,
	1.67887564412e+002, 4.57197726936e-073,
	1.71654828257e+002, 1.07288511513e-074,
	1.75479378281e+002, 2.37755286790e-076,
	1.79362157699e+002, 4.97081611333e-078,
	1.83304148121e+002, 9.79539362351e-080,
	1.87306371741e+002, 1.81748708834e-081,
	1.91369893695e+002, 3.17187459753e-083,
	1.95495824604e+002, 5.20087272854e-085,
	1.99685323320e+002, 8.00297454078e-087,
	2.03939599898e+002, 1.15430065764e-088,
	2.08259918807e+002, 1.55859230379e-090,
	2.12647602423e+002, 1.96752804946e-092,
	2.17104034816e+002, 2.31892250047e-094,
	2.21630665875e+002, 2.54801548909e-096,
	2.26229015798e+002, 2.60622355508e-098,
	2.30900680003e+002, 2.47756915527e-100,
	2.35647334495e+002, 2.18534673612e-102,
	2.40470741746e+002, 1.78539349542e-104,
	2.45372757161e+002, 1.34854365350e-106,
	2.50355336186e+002, 9.39872136358e-109,
	2.55420542151e+002, 6.03189670945e-111,
	2.60570554943e+002, 3.55695773002e-113,
	2.65807680615e+002, 1.92285734544e-115,
	2.71134362059e+002, 9.50613072576e-118,
	2.76553190908e+002, 4.28676292907e-120,
	2.82066920812e+002, 1.75846940173e-122,
	2.87678482336e+002, 6.54265772153e-125,
	2.93390999686e+002, 2.20109332655e-127,
	2.99207809580e+002, 6.67339388508e-130,
	3.05132482604e+002, 1.81692678004e-132,
	3.11168847461e+002, 4.42545043718e-135,
	3.17321018625e+002, 9.60352668485e-138,
	3.23593428010e+002, 1.84860541301e-140,
	3.29990861388e+002, 3.14146624392e-143,
	3.36518500480e+002, 4.68877262138e-146,
	3.43181971837e+002, 6.11218949986e-149,
	3.49987403937e+002, 6.91673917409e-152,
	3.56941494254e+002, 6.74969295445e-155,
	3.64051588545e+002, 5.63866976697e-158,
	3.71325775226e+002, 4.00029200602e-161,
	3.78772998556e+002, 2.38876398927e-164,
	3.86403195455e+002, 1.18888116784e-167,
	3.94227462382e+002, 4.87759614781e-171,
	4.02258260859e+002, 1.62932291896e-174,
	4.10509673306e+002, 4.36996223678e-178,
	4.18997725315e+002, 9.26228219817e-182,
	4.27740797022e+002, 1.52341378331e-185,
	4.36760156068e+002, 1.90382909227e-189,
	4.46080659776e+002, 1.76384067777e-193,
	4.55731698124e+002, 1.17673968875e-197,
	4.65748488274e+002, 5.45963423569e-202,
	4.76173897758e+002, 1.68852332899e-206,
	4.87061090766e+002, 3.30298473856e-211,
	4.98477510053e+002, 3.82348192487e-216,
	5.10511137511e+002, 2.40159744621e-221,
	5.23280891335e+002, 7.28098900847e-227,
	5.36955151513e+002, 9.02955930486e-233,
	5.51788025675e+002, 3.57045128800e-239,
	5.68200475193e+002, 2.98315560287e-246,
	5.87003610243e+002, 2.39306017333e-254,
	6.10303088232e+002, 2.42528228004e-264
};

// Generalized Gauss-Laguerre Abscissas and weights 
// for Int(, inf) x**(-1/2) exp(-x) f(x) dx, By P. Concus et al.
const double GauGenLagAbscWei_14[14][2] =
{
	0.0432920357397735, 0.797209435652903,
	0.390420926042032, 0.565122782518777,
	1.088965867569270, 0.282789219573910,
	2.147799470582232, 0.990297785797963e-1,
	3.581028249991771, 0.239368464287096e-1,
	5.409112330616460, 0.391466258881798e-2,
	7.660691115610085, 0.421236200048065e-3,
	10.375563009770052, 0.286910084594288e-4,
	13.609711429390236, 0.117154394419860e-5,
	17.444294475704189, 0.265136500308342e-7,
	22.003196766914923, 0.295170633655538e-9,
	27.092041504843852, 0.132788734298193e-11,
	34.304620509373083, 0.166318759024137e-14,
	43.449262307852043, 0.228027869580735e-18
};

const double GauGenLagAbscWei_15[15][2] =
{
	0.0404527043045753, 0.772789779083628,
	0.364720645051408, 0.560261861678425,
	1.016746068857496, 0.293471695081780,
	2.007318953133923, 0.110288353740469,
	3.336983205734510, 0.294076594096534e-1,
	5.032805277625116, 0.547584494613532e-2,
	7.113593769729875, 0.696620248637371e-3,
	9.609817284304444, 0.587745045784598e-4,
	12.563082369948498, 0.315818977464942e-5,
	16.031284108073975, 0.102170449015519e-6,
	20.097785334755927, 0.183571608487571e-8,
	24.889312475156550, 0.162123725949261e-10,
	30.615717400899492, 0.575721416109741e-13,
	37.678471784205299, 0.562066720550181e-16,
	47.105508618218914, 0.581650940026245e-20
};


// Gauss points in triangles, some of the rules you will find at burkhard
// and the strang nodes, warning: some of these rules have negative weights
const double GAUCORWEI_TR1[][3] = /* order 1, Argyris p 420 */
{
	{
		1.0/3.0, 1.0/3.0, 0.5
	}
};

const double GAUCORWEI_TR3[][3] = /* order 2 */
{
	{
		1.0/6.0, 1.0/6.0, 1.0/6.0
	},
	{
		2.0/3.0, 1.0/6.0, 1.0/6.0
	},
	{
		1.0/6.0, 2.0/3.0, 1.0/6.0
	}
};

const double GAUCORWEI_TR4[][3] = /* order 3 */
{
	{
		1.0/3.0, 1.0/3.0, -27.0/96.0
	},
	{
		0.2, 0.2, 25.0/96.0
	},
	{
		0.6, 0.2, 25.0/96.0
	},
	{
		0.2, 0.6, 25.0/96.0
	}
};

const double GAUCORWEI_TR6[][3] = /* order 4 */
{
	{
		0.8168475729804585, 0.5*(1.0 - 0.8168475729804585), 0.1099517436553219/2.0
	},
	{
		0.5*(1.0 - 0.8168475729804585), 0.8168475729804585, 0.1099517436553219/2.0
	},
	/* used to be a slight error, but it was never called
	{
		0.8168475729804585, 0.8168475729804585, 0.1099517436553219/2.0
	},
	*/
	// now its correct
	{
	  0.5*(1.0 - 0.8168475729804585), 0.5*(1.0 - 0.8168475729804585),0.1099517436553219/2.0
	},
	{
		0.1081030181680702, 0.5*(1.0 - 0.1081030181680702), 
		1.0/6.0 - 0.1099517436553219/2.0
	},
	{
		0.5*(1.0 - 0.1081030181680702), 0.1081030181680702,
		1.0/6.0 - 0.1099517436553219/2.0
	},
	{
		0.5*(1.0 - 0.1081030181680702), 0.5*(1.0 - 0.1081030181680702),
		1.0/6.0 - 0.1099517436553219/2.0
	}
};

const double GAUCORWEI_TR7[][3] = /* order 5,  K.-J. Bathe p 547*/
{
	{
		0.1012865073235, 0.1012865073235, 0.1259391805448/2.0
	},
	{
		0.7974269853531, 0.1012865073235, 0.1259391805448/2.0
	},
	{
		0.1012865073235, 0.7974269853531, 0.1259391805448/2.0
	},
	{
		0.4701420641051, 0.0597158717898, 0.1323941527885/2.0
	},
	{
		0.4701420641051, 0.4701420641051, 0.1323941527885/2.0
	},
	{
		0.0597158717898, 0.4701420641051, 0.1323941527885/2.0
	},
	{
		0.3333333333333, 0.3333333333333, 0.225/2.0
	}
};

const double GAUCORWEI_TR13[][3] = /* order 7 */
{
	{
		0.0651301029022, 0.0651301029022, 0.0533472356088/2.0	
	},
	{
		0.8697397941956, 0.0651301029022, 0.0533472356088/2.0
	},
	{
		0.0651301029022, 0.8697397941956, 0.0533472356088/2.0
	},
	{
		0.3128654960049, 0.0486903154253, 0.0771137608903/2.0
	},
	{
		0.6384441885698, 0.3128654960049, 0.0771137608903/2.0
	},
	{
		0.0486903154253, 0.6384441885698, 0.0771137608903/2.0		
	},
	{
		0.6384441885698, 0.0486903154253, 0.0771137608903/2.0		
	},
	{
		0.3128654960049, 0.6384441885698, 0.0771137608903/2.0		
	},
	{
		0.0486903154253, 0.3128654960049, 0.0771137608903/2.0		
	},
	{
		0.2603459660790, 0.2603459660790, 0.1756152574332/2.0
	},
	{
		0.4793080678419, 0.2603459660790, 0.1756152574332/2.0		
	},
	{
		0.2603459660790, 0.4793080678419, 0.1756152574332/2.0		
	},
	{
		0.3333333333333, 0.3333333333333, -0.1495700444677/2.0
	}
};


#endif /* Don't add any thing after this line! */
